/*
 * Decompiled with CFR 0.152.
 */
package terraml.geometry.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import terraml.commons.Doubles;
import terraml.commons.math.Interval;
import terraml.commons.math.Vec3d;
import terraml.commons.unit.DimensionUnit;
import terraml.geometry.Point3D;
import terraml.geometry.Segment3D;
import terraml.geometry.ShapeUnit;
import terraml.geometry.impl.ImmutableLine3D;
import terraml.geometry.impl.ImmutablePoint3D;

public class ImmutableSegment3D
implements Segment3D,
Serializable {
    private final Point3D _source;
    private final Point3D _target;

    public ImmutableSegment3D(Point3D source, Point3D target) {
        this._source = source;
        this._target = target;
    }

    public ImmutableSegment3D(Segment3D segment3D) {
        this(segment3D.getSource(), segment3D.getTarget());
    }

    protected Point3D closestPoint(Segment3D _s0, Point3D _p0) {
        Vec3d _v0 = _s0.getSource().toVector();
        Vec3d _v1 = _s0.getTarget().toVector();
        Vec3d _v2 = _p0.toVector();
        Vec3d _v3 = _v1.sub(_v0);
        Vec3d _v4 = _v2.sub(_v0);
        double _let0 = _v4.getDotProduct(_v3);
        double _let1 = _v3.getDotProduct(_v3);
        if (Doubles.isSmallerEqual((double)_let0, (double)0.0)) {
            return _s0.getSource();
        }
        if (Doubles.isSmallerEqual((double)_let1, (double)_let0)) {
            return _s0.getTarget();
        }
        Vec3d _v5 = _v3.scale(_let0 / _let1);
        Vec3d _v6 = new Vec3d(_v5.getX(), _v5.getY(), _v5.getZ());
        Vec3d _v7 = _v0.add(_v6);
        return new ImmutablePoint3D(_v7.x, _v7.y, _v7.z);
    }

    @Override
    public Point3D closestPoint(Point3D point3D) {
        return this.closestPoint(this, point3D);
    }

    @Override
    public double project(Point3D point3D) {
        Vec3d _src = this._source.toVector();
        Vec3d _dst = this._target.toVector();
        Vec3d _dirr = _dst.sub(_src);
        ImmutableLine3D _line0 = new ImmutableLine3D(this._source, _dirr);
        double _proj = _line0.project(point3D);
        return Math.min(Math.max(_proj, 0.0), 1.0);
    }

    @Override
    public Point3D point(double scalar) {
        double _let0 = Math.max(Math.min(scalar, 1.0), 0.0);
        Vec3d _src = this._source.toVector();
        Vec3d _dst = this._target.toVector();
        Vec3d _v0 = _dst.sub(_src);
        double _x0 = this._source.getX() + _v0.x * _let0;
        double _y0 = this._source.getY() + _v0.y * _let0;
        double _z0 = this._source.getZ() + _v0.z * _let0;
        return new ImmutablePoint3D(_x0, _y0, _z0);
    }

    @Override
    public double distanceTo(Point3D point3D) {
        if (this._source.equals(this._target)) {
            return this._source.distanceTo(point3D);
        }
        Vec3d _src = this._source.toVector();
        Vec3d _dst = this._target.toVector();
        Vec3d _ptr = point3D.toVector();
        Vec3d _v0 = _dst.sub(_src);
        Vec3d _v1 = _ptr.sub(_src);
        double _let0 = _v1.getDotProduct(_v0);
        if (Doubles.isSmallerEqual((double)_let0, (double)0.0)) {
            return _v1.getNorm();
        }
        Vec3d _v2 = _ptr.sub(_dst);
        if (Doubles.isGreaterEqual((double)_v2.getDotProduct(_v1), (double)0.0)) {
            return _v2.getNorm();
        }
        return _v0.getCrossProduct(_v1).getNorm() / _v0.getNorm();
    }

    private double _distanceTo2(Point3D point3D) {
        double _let0 = this.project(point3D);
        return this.point(_let0).distanceTo(point3D);
    }

    @Override
    public Vec3d getDirection() {
        Vec3d _src = this._source.toVector();
        Vec3d _dst = this._target.toVector();
        return _dst.sub(_src).getNormalized();
    }

    @Override
    public double getLength() {
        return this._source.distanceTo(this._target);
    }

    @Override
    public Point3D getSource() {
        return this._source;
    }

    @Override
    public Point3D getTarget() {
        return this._target;
    }

    @Override
    public boolean isHorizontal() {
        return Doubles.isEqual((double)this._source.getY(), (double)this._target.getY());
    }

    @Override
    public boolean isVertical() {
        return Doubles.isEqual((double)this._source.getX(), (double)this._target.getX());
    }

    @Override
    public List<Point3D> getBounds() {
        Interval _xBound = new Interval(this._source.getX(), this._target.getX());
        Interval _yBound = new Interval(this._source.getY(), this._target.getY());
        Interval _zBound = new Interval(this._source.getZ(), this._target.getZ());
        ImmutablePoint3D _lowerBounding = new ImmutablePoint3D(_xBound.left, _yBound.left, _zBound.left);
        ImmutablePoint3D _upperBounding = new ImmutablePoint3D(_xBound.right, _yBound.right, _zBound.right);
        return Arrays.asList(_lowerBounding, _upperBounding);
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public ImmutableSegment3D copy() {
        return new ImmutableSegment3D(this._source, this._target);
    }

    @Override
    public DimensionUnit getDimensionUnit() {
        return DimensionUnit.THREE;
    }

    @Override
    public ShapeUnit getShapeUnit() {
        return ShapeUnit.SEGMENT;
    }

    @Override
    public Segment3D translate(double ... args) {
        Point3D p0 = this.getSource().translate(args);
        Point3D p1 = this.getTarget().translate(args);
        return new ImmutableSegment3D(p0, p1);
    }

    @Override
    public Segment3D scale(double scaleFactor) {
        Point3D p0 = this.getSource().scale(scaleFactor);
        Point3D p1 = this.getTarget().scale(scaleFactor);
        return new ImmutableSegment3D(p0, p1);
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + Objects.hashCode(this._source);
        hash = 29 * hash + Objects.hashCode(this._target);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableSegment3D other = (ImmutableSegment3D)obj;
        if (!Objects.equals(this._source, other._source)) {
            return false;
        }
        return Objects.equals(this._target, other._target);
    }
}

