/*
 * Decompiled with CFR 0.152.
 */
package terraml.geometry.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import terraml.commons.Doubles;
import terraml.commons.math.Interval;
import terraml.commons.math.Vec2d;
import terraml.commons.unit.DimensionUnit;
import terraml.geometry.Point2D;
import terraml.geometry.Segment2D;
import terraml.geometry.ShapeUnit;
import terraml.geometry.impl.ImmutablePoint2D;

public class ImmutableSegment2D
implements Segment2D,
Serializable {
    private final Point2D _source;
    private final Point2D _target;

    public ImmutableSegment2D(double x0, double y0, double x1, double y1) {
        this._source = new ImmutablePoint2D(x0, y0);
        this._target = new ImmutablePoint2D(x1, y1);
    }

    public ImmutableSegment2D(Point2D _source, Point2D _target) {
        this._source = _source;
        this._target = _target;
    }

    public ImmutableSegment2D(Segment2D segment2D) {
        this._source = segment2D.getSource();
        this._target = segment2D.getTarget();
    }

    protected boolean onRange(Segment2D _s0, Point2D _p0, double _tolerance) {
        double _srcX = _s0.getSource().getX();
        double _srcY = _s0.getSource().getY();
        double _tarX = _s0.getTarget().getX();
        double _tarY = _s0.getTarget().getY();
        double _p0x = _p0.getX();
        double _p0y = _p0.getY();
        if (Doubles.isEqual((double)_srcX, (double)_tarX) && Doubles.isEqual((double)_srcX, (double)_p0x) && Doubles.isEqual((double)_srcY, (double)_tarY) && Doubles.isEqual((double)_srcY, (double)_p0y)) {
            return true;
        }
        double _let0 = (_tarY - _srcY) / (_tarX - _srcX);
        double _let1 = _srcY - _let0 * _srcX;
        double _let2 = Math.abs(_p0y - (_let0 * _p0x + _let1));
        return Doubles.isSmaller((double)_let2, (double)_tolerance);
    }

    @Override
    public boolean onRange(Point2D point2D, double tolerance) {
        return this.onRange(this, point2D, tolerance);
    }

    protected boolean inRange(Segment2D _s0, Point2D _p0, double _tolerance) {
        double _letY;
        double _srcX = _s0.getSource().getX();
        double _srcY = _s0.getTarget().getY();
        double _p0x = _p0.getX();
        double _letX = _srcX <= _srcY ? _srcX : _srcY;
        double d = _letY = _srcX > _srcY ? _srcX : _srcY;
        if (this.onRange(_s0, _p0, _tolerance)) {
            double cod = _p0x + _tolerance;
            return Doubles.isSmallerEqual((double)cod, (double)_letX) && Doubles.isSmaller((double)cod, (double)_letY);
        }
        return false;
    }

    @Override
    public boolean inRange(Point2D point2D, double tolerance) {
        return this.inRange(this, point2D, tolerance);
    }

    protected boolean inRange(Segment2D _s0, Point2D _p0) {
        double _letY;
        double _p0y;
        double _letX;
        double _srcX = _s0.getSource().getX();
        double _srcY = _s0.getTarget().getY();
        double _tarX = _s0.getTarget().getX();
        double _tarY = _s0.getTarget().getY();
        double _p0x = _p0.getX();
        double _let = (_p0x - _srcX) * (_letX = _tarX - _srcX) + ((_p0y = _p0.getY()) - _srcY) * (_letY = _tarY - _srcY);
        return Doubles.isSmallerEqual((double)0.0, (double)_let) && Doubles.isSmallerEqual((double)_let, (double)(_letX * _letX + _letY * _letY));
    }

    @Override
    public boolean inRange(Point2D point2D) {
        return this.inRange(this, point2D);
    }

    protected Point2D directionOf(Segment2D _s0) {
        Vec2d _v0 = _s0.getSource().toVector();
        Vec2d _v1 = _s0.getTarget().toVector();
        Vec2d _v2 = _v1.sub(_v0);
        Vec2d _v3 = _v2.getNormalized();
        return new ImmutablePoint2D(_v3.getX(), _v3.getY());
    }

    @Override
    public Point2D direction() {
        return this.directionOf(this);
    }

    @Override
    public boolean isVertical() {
        return Doubles.isEqual((double)this._source.getX(), (double)this._target.getX());
    }

    @Override
    public boolean isHorizontal() {
        return Doubles.isEqual((double)this._source.getY(), (double)this._target.getY());
    }

    @Override
    public double horizontalAngle() {
        return this._source.angleTo(this._target);
    }

    @Override
    public double verticalAngle() {
        double dx = this._target.getX() - this._source.getX();
        double dy = this._target.getY() - this._source.getY();
        return Math.atan2(dx, dy);
    }

    @Override
    public double getLength() {
        return this._source.distanceTo(this._target);
    }

    @Override
    public Point2D getMiddle() {
        double _dx = this._source.getX() + this._target.getX();
        double _dy = this._source.getY() + this._target.getY();
        return new ImmutablePoint2D(_dx / 2.0, _dy / 2.0);
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public List<Point2D> getBounds() {
        Interval _xBound = new Interval(this._source.getX(), this._target.getX());
        Interval _yBound = new Interval(this._source.getY(), this._target.getY());
        ImmutablePoint2D _lowerBounding = new ImmutablePoint2D(_xBound.getLeft(), _yBound.getLeft());
        ImmutablePoint2D _upperBounding = new ImmutablePoint2D(_xBound.getRight(), _yBound.getRight());
        return Arrays.asList(_lowerBounding, _upperBounding);
    }

    @Override
    public DimensionUnit getDimensionUnit() {
        return DimensionUnit.TWO;
    }

    @Override
    public ShapeUnit getShapeUnit() {
        return ShapeUnit.SEGMENT;
    }

    @Override
    public Point2D getSource() {
        return new ImmutablePoint2D(this._source);
    }

    @Override
    public Point2D getTarget() {
        return new ImmutablePoint2D(this._target);
    }

    @Override
    public Segment2D copy() {
        return new ImmutableSegment2D(this.getSource(), this.getTarget());
    }

    @Override
    public Segment2D translate(double ... args) {
        Point2D p0 = this.getSource().translate(args);
        Point2D p1 = this.getTarget().translate(args);
        return new ImmutableSegment2D(p0, p1);
    }

    @Override
    public Segment2D scale(double scaleFactor) {
        Point2D p0 = this.getSource().scale(scaleFactor);
        Point2D p1 = this.getTarget().scale(scaleFactor);
        return new ImmutableSegment2D(p0, p1);
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + Objects.hashCode(this._source);
        hash = 67 * hash + Objects.hashCode(this._target);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableSegment2D other = (ImmutableSegment2D)obj;
        if (!Objects.equals(this._source, other._source)) {
            return false;
        }
        return Objects.equals(this._target, other._target);
    }
}

