/*
 * Decompiled with CFR 0.152.
 */
package terraml.geometry.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import terraml.commons.Doubles;
import terraml.commons.Ints;
import terraml.commons.Objects;
import terraml.commons.math.Vec2d;
import terraml.commons.unit.DimensionUnit;
import terraml.geometry.Point2D;
import terraml.geometry.Polygon2D;
import terraml.geometry.ShapeUnit;
import terraml.geometry.impl.ImmutablePoint2D;

public class ImmutablePolygon2D
implements Polygon2D,
Serializable {
    private final List<Point2D> _vertices;

    public ImmutablePolygon2D(List<Point2D> _vertices) {
        this._vertices = _vertices;
    }

    public ImmutablePolygon2D(Polygon2D polygon2D) {
        this._vertices = polygon2D.getVertices();
    }

    protected int _findMaxOrMin(boolean isMax, boolean isX) {
        double ref = isMax ? 0.0 : Double.MAX_VALUE;
        int idx = -1;
        for (int t = 0; t < this.getVerticesCount(); ++t) {
            double temp;
            double d = temp = isX ? this._vertices.get(t).getX() : this._vertices.get(t).getY();
            if (isMax) {
                if (!(temp > ref)) continue;
                idx = t;
                ref = temp;
                continue;
            }
            if (!(temp < ref)) continue;
            idx = t;
            ref = temp;
        }
        return idx;
    }

    @Override
    public boolean isConvex() {
        if (Objects.isNull(this._vertices) || this._vertices.size() <= 4) {
            return false;
        }
        Polygon2D _instance = this.isClosed() ? this.open() : this;
        int _length = _instance.getVerticesCount();
        boolean control = false;
        for (int t = 0; t < _length; ++t) {
            Point2D Qx = this._vertices.get((t + 2) % _length);
            Point2D Qy = this._vertices.get((t + 1) % _length);
            Point2D Qz = this._vertices.get(t);
            Vec2d _x = Qx.toVector();
            Vec2d _y = Qy.toVector();
            Vec2d _z = Qz.toVector();
            Vec2d _diff0 = _x.sub(_y);
            Vec2d _diff1 = _z.sub(_y);
            ImmutablePoint2D Wx = new ImmutablePoint2D(_diff0.getX(), _diff0.getY());
            ImmutablePoint2D Wy = new ImmutablePoint2D(_diff1.getX(), _diff1.getY());
            double _crossP = Wx.getX() * Wy.getY() - Wx.getY() * Wy.getX();
            if (Ints.isEqual((int)t, (int)0)) {
                control = Doubles.isGreater((double)_crossP, (double)0.0);
                continue;
            }
            if (control == Doubles.isGreater((double)_crossP, (double)0.0)) continue;
            return false;
        }
        return true;
    }

    protected Polygon2D differenceOf(Polygon2D _poly0, Polygon2D _poly1) {
        if (!Ints.isEqual((int)_poly0.getVerticesCount(), (int)_poly1.getVerticesCount())) {
            throw new IllegalStateException("dimensions are not fit.");
        }
        ArrayList<Point2D> _verts = new ArrayList<Point2D>();
        for (int i = 0; i < _poly0.getVerticesCount(); ++i) {
            double _letX = _poly0.getVertices().get(i).getX() - _poly1.getVertices().get(i).getX();
            double _letY = _poly0.getVertices().get(i).getY() - _poly1.getVertices().get(i).getY();
            _verts.add(new ImmutablePoint2D(_letX, _letY));
        }
        return new ImmutablePolygon2D(_verts);
    }

    @Override
    public Polygon2D diffrence(Polygon2D polygon2D) {
        return this.differenceOf(this, polygon2D);
    }

    @Override
    public boolean isClosed() {
        int _length = this.getVerticesCount();
        if (_length == 0) {
            return true;
        }
        Point2D _origin = this._vertices.get(0);
        Point2D _end = this._vertices.get(_length - 1);
        return _origin.equals(_end);
    }

    protected double areaOf(Polygon2D _poly0) {
        int _length = _poly0.getVerticesCount();
        double _let0 = 0.0;
        Point2D _lastPoint = _poly0.getVertices().get(_length - 1);
        for (Point2D each : _poly0.getVertices()) {
            _let0 += _lastPoint.getX() * each.getY() - _lastPoint.getY() * each.getX();
            _lastPoint = each;
        }
        return _let0;
    }

    @Override
    public double area() {
        return this.areaOf(this);
    }

    @Override
    public Point2D at(int index) {
        if (Ints.isGreater((int)index, (int)this.getVerticesCount())) {
            return null;
        }
        return this._vertices.get(index);
    }

    @Override
    public int getVerticesCount() {
        if (Objects.isNull(this._vertices) || this._vertices.isEmpty()) {
            return 0;
        }
        return this._vertices.size();
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public List<Point2D> getBounds() {
        double _greatestX = this._vertices.get(this._findMaxOrMin(true, true)).getX();
        double _greatestY = this._vertices.get(this._findMaxOrMin(false, true)).getY();
        double _smallestX = this._vertices.get(this._findMaxOrMin(true, false)).getX();
        double _smallestY = this._vertices.get(this._findMaxOrMin(false, false)).getY();
        ImmutablePoint2D _lowerBound = new ImmutablePoint2D(_smallestX, _smallestY);
        ImmutablePoint2D _upperBound = new ImmutablePoint2D(_greatestX, _greatestY);
        return Arrays.asList(_lowerBound, _upperBound);
    }

    @Override
    public DimensionUnit getDimensionUnit() {
        return DimensionUnit.TWO;
    }

    @Override
    public ShapeUnit getShapeUnit() {
        return ShapeUnit.POLYGON;
    }

    @Override
    public Polygon2D addVertex(Point2D point2D) {
        ArrayList<Point2D> _vertx = new ArrayList<Point2D>(this.getVertices());
        _vertx.add(point2D);
        return new ImmutablePolygon2D(_vertx);
    }

    @Override
    public Polygon2D removeVertex(Point2D point2D) {
        ArrayList<Point2D> _vertx = new ArrayList<Point2D>(this.getVertices());
        _vertx.remove(point2D);
        return new ImmutablePolygon2D(_vertx);
    }

    @Override
    public Polygon2D close() {
        if (this.isClosed() || this._vertices.isEmpty()) {
            return this;
        }
        Point2D _origin = this.getVertices().get(0);
        ArrayList<Point2D> _vertx = new ArrayList<Point2D>(this.getVertices());
        _vertx.add(_origin);
        return new ImmutablePolygon2D(_vertx);
    }

    @Override
    public Polygon2D open() {
        if (!this.isClosed() || this._vertices.isEmpty()) {
            return this;
        }
        int _length = this.getVerticesCount();
        ArrayList<Point2D> _vertx = new ArrayList<Point2D>(this._vertices);
        _vertx.remove(_length - 1);
        return new ImmutablePolygon2D(_vertx);
    }

    @Override
    public List<Point2D> getVertices() {
        return new ArrayList<Point2D>(this._vertices);
    }

    @Override
    public ImmutablePolygon2D copy() {
        return new ImmutablePolygon2D(this.getVertices());
    }

    @Override
    public Polygon2D translate(double ... args) {
        if (Objects.isNull(this._vertices) || this._vertices.isEmpty()) {
            return this;
        }
        ArrayList<Point2D> list = new ArrayList<Point2D>();
        for (Point2D current : this._vertices) {
            list.add(current.translate(args));
        }
        return new ImmutablePolygon2D(list);
    }

    @Override
    public Polygon2D scale(double scaleFactor) {
        if (Objects.isNull(this._vertices) || this._vertices.isEmpty()) {
            return this;
        }
        ArrayList<Point2D> list = new ArrayList<Point2D>();
        for (Point2D current : this._vertices) {
            list.add(current.scale(scaleFactor));
        }
        return new ImmutablePolygon2D(list);
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + java.util.Objects.hashCode(this._vertices);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutablePolygon2D other = (ImmutablePolygon2D)obj;
        return java.util.Objects.equals(this._vertices, other._vertices);
    }
}

