/*
 * Decompiled with CFR 0.152.
 */
package terraml.geometry.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import terraml.commons.Doubles;
import terraml.commons.Objects;
import terraml.commons.math.Angle;
import terraml.commons.math.Vec3d;
import terraml.geometry.Point3D;

public class ImmutablePoint3D
implements Point3D,
Serializable {
    private final double x;
    private final double y;
    private final double z;

    public ImmutablePoint3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public ImmutablePoint3D(Point3D point3D) {
        this.x = point3D.getX();
        this.y = point3D.getY();
        this.z = point3D.getZ();
    }

    @Override
    public double cosine(Point3D point3D) {
        double _dn;
        Vec3d _vec1;
        Vec3d _vec0 = this.toVector();
        double _dist = _vec0.distanceSquaredTo(_vec1 = point3D.toVector());
        double _calculation = _dist / (_dn = _vec0.getNorm() * _vec1.getNorm());
        if (Doubles.isEqual((double)Math.abs(_calculation), (double)1.0)) {
            return Doubles.isEqual((double)_calculation, (double)1.0) ? 1.0 : -1.0;
        }
        return _calculation;
    }

    @Override
    public double distanceTo(Point3D point3D) {
        Vec3d _vec0 = this.toVector();
        Vec3d _vec1 = point3D.toVector();
        return _vec0.distanceTo(_vec1);
    }

    @Override
    public double angleTo(Point3D shape) {
        double _formula = (shape.getX() * this.x + shape.getY() * this.y + shape.getZ() * this.z) / Math.sqrt((shape.getX() * shape.getX() + shape.getY() * shape.getY() + shape.getZ() * shape.getZ()) * (this.x * this.x + this.y * this.y + this.z * this.z));
        if (Doubles.isGreater((double)_formula, (double)1.0)) {
            return Angle.fromDegree((double)0.0).degree;
        }
        if (Doubles.isSmaller((double)_formula, (double)-1.0)) {
            return Angle.fromDegree((double)180.0).degree;
        }
        return Angle.fromRadian((double)Math.acos((double)_formula)).degree;
    }

    @Override
    public boolean isParallel(Point3D _p1) {
        return Doubles.isEqual((double)this.cosine(_p1), (double)1.0);
    }

    @Override
    public boolean isAntiParallel(Point3D _p1) {
        return Doubles.isEqual((double)this.cosine(_p1), (double)-1.0);
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public double[] toArray() {
        return new double[]{this.x, this.y, this.z};
    }

    @Override
    public Vec3d toVector() {
        return new Vec3d(this.x, this.y, this.z);
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public List<Point3D> getBounds() {
        ImmutablePoint3D _xBound = new ImmutablePoint3D(this.x, this.x, this.x);
        ImmutablePoint3D _yBound = new ImmutablePoint3D(this.y, this.y, this.y);
        ImmutablePoint3D _zBound = new ImmutablePoint3D(this.z, this.z, this.z);
        return Arrays.asList(_xBound, _yBound, _zBound);
    }

    @Override
    public ImmutablePoint3D copy() {
        return new ImmutablePoint3D(this.x, this.y, this.z);
    }

    @Override
    public Point3D translate(double ... args) {
        if (Objects.isNull((Object)args) || args.length == 0) {
            return this.copy();
        }
        if (args.length == 1) {
            double newX = this.getX() + args[0];
            double newY = this.getY() + args[0];
            double newZ = this.getZ() + args[0];
            return new ImmutablePoint3D(newX, newY, newZ);
        }
        if (args.length == 2) {
            double newX = this.getX() + args[0];
            double newY = this.getY() + args[1];
            return new ImmutablePoint3D(newX, newY, this.getZ());
        }
        double newX = this.getX() + args[0];
        double newY = this.getY() + args[1];
        double newZ = this.getZ() + args[2];
        return new ImmutablePoint3D(newX, newY, newZ);
    }

    @Override
    public Point3D scale(double scaleFactor) {
        double newX = this.getX() * scaleFactor;
        double newY = this.getY() * scaleFactor;
        double newZ = this.getZ() * scaleFactor;
        return new ImmutablePoint3D(newX, newY, newZ);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (int)(Double.doubleToLongBits(this.x) ^ Double.doubleToLongBits(this.x) >>> 32);
        hash = 31 * hash + (int)(Double.doubleToLongBits(this.y) ^ Double.doubleToLongBits(this.y) >>> 32);
        hash = 31 * hash + (int)(Double.doubleToLongBits(this.z) ^ Double.doubleToLongBits(this.z) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutablePoint3D other = (ImmutablePoint3D)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(other.y)) {
            return false;
        }
        return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(other.z);
    }
}

