/*
 * Decompiled with CFR 0.152.
 */
package terraml.geometry.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import terraml.commons.Doubles;
import terraml.commons.Objects;
import terraml.commons.math.Vec2d;
import terraml.commons.unit.DirectionUnit;
import terraml.geometry.Point2D;

public class ImmutablePoint2D
implements Point2D,
Serializable {
    private final double x;
    private final double y;

    public ImmutablePoint2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public ImmutablePoint2D(Point2D point2D) {
        this.x = point2D.getX();
        this.y = point2D.getY();
    }

    @Override
    public int ccw(Point2D _p0, Point2D _p1) {
        Vec2d _v2;
        Vec2d _v1;
        Vec2d _v0 = this.toVector();
        double _crossP = _v0.getCrossProduct(_v1 = _p0.toVector(), _v2 = _p1.toVector());
        if (Doubles.isSmaller((double)_crossP, (double)0.0)) {
            return -1;
        }
        if (Doubles.isGreater((double)_crossP, (double)0.0)) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isBetween(Point2D _p0, Point2D _p1) {
        if (!Doubles.isEqual((double)this.ccw(_p0, _p1), (double)0.0)) {
            return false;
        }
        boolean _let0 = Doubles.isEqual((double)_p0.getX(), (double)_p1.getX());
        boolean _let1 = Doubles.isEqual((double)_p0.getX(), (double)_p1.getY());
        if (_let0 && _let1) {
            return Doubles.isEqual((double)_p0.getX(), (double)this.getX()) && Doubles.isEqual((double)_p0.getY(), (double)this.getY());
        }
        if (!_let0) {
            boolean _let2 = Doubles.isSmallerEqual((double)_p0.getX(), (double)this.getX()) && Doubles.isSmallerEqual((double)this.getX(), (double)_p1.getX());
            boolean _let3 = Doubles.isGreaterEqual((double)_p0.getX(), (double)this.getX()) && Doubles.isGreaterEqual((double)this.getX(), (double)_p1.getX());
            return _let2 || _let3;
        }
        boolean _let4 = Doubles.isSmallerEqual((double)_p0.getY(), (double)this.getY()) && Doubles.isSmallerEqual((double)this.getY(), (double)_p1.getY());
        boolean _let5 = Doubles.isGreaterEqual((double)_p0.getY(), (double)this.getY()) && Doubles.isGreaterEqual((double)this.getY(), (double)_p1.getY());
        return _let4 || _let5;
    }

    protected DirectionUnit directionTo(Point2D _p0, Point2D _p1) {
        ImmutablePoint2D difference = new ImmutablePoint2D(_p1.getX() - _p0.getX(), _p1.getY() - _p0.getY());
        boolean _letX = Doubles.isEqual((double)difference.getX(), (double)0.0);
        boolean _letY = Doubles.isEqual((double)difference.getY(), (double)0.0);
        if (_letX && _letY) {
            return null;
        }
        if (_letX) {
            return Doubles.isGreater((double)difference.getY(), (double)0.0) ? DirectionUnit.NORTH : DirectionUnit.SOUTH;
        }
        if (_letY) {
            return Doubles.isGreater((double)difference.getX(), (double)0.0) ? DirectionUnit.EAST : DirectionUnit.WEST;
        }
        boolean diffY = Doubles.isGreater((double)difference.getY(), (double)0.0);
        if (Doubles.isGreater((double)difference.getX(), (double)0.0)) {
            return diffY ? DirectionUnit.NORTH_EAST : DirectionUnit.SOUTH_EAST;
        }
        return diffY ? DirectionUnit.NORTH_WEST : DirectionUnit.SOUTH_WEST;
    }

    @Override
    public DirectionUnit directionTo(Point2D point2D) {
        return this.directionTo(this, point2D);
    }

    protected boolean isCollinearWith(Point2D _thePoint, Point2D _p0, Point2D _p1) {
        Vec2d _v0 = _thePoint.toVector();
        Vec2d _v1 = _p0.toVector();
        Vec2d _v2 = _p1.toVector();
        return Doubles.isSmaller((double)Math.abs(_v0.getCrossProduct(_v1, _v2)), (double)1.0E-8);
    }

    @Override
    public boolean isCollinearWith(Point2D p0, Point2D p1) {
        return this.isCollinearWith(this, p0, p1);
    }

    @Override
    public Point2D centroidOf(List<Point2D> _ptrList) {
        double _letX = 0.0;
        double _letY = 0.0;
        for (int i = 0; i < _ptrList.size(); ++i) {
            _letX += _ptrList.get(i).getX();
            _letY += _ptrList.get(i).getY();
        }
        return new ImmutablePoint2D(_letX /= (double)_ptrList.size(), _letY /= (double)_ptrList.size());
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double angleTo(Point2D point2D) {
        double _dx = point2D.getX() - this.x;
        double _dy = point2D.getY() - this.y;
        double theta = Math.atan2(_dy, _dx);
        return Math.toDegrees(theta);
    }

    @Override
    public double distanceTo(Point2D point2D) {
        Vec2d _vec0 = this.toVector();
        Vec2d _vec1 = point2D.toVector();
        return _vec0.distanceTo(_vec1);
    }

    @Override
    public double[] toArray() {
        return new double[]{this.x, this.y};
    }

    @Override
    public Vec2d toVector() {
        return new Vec2d(this.x, this.y);
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public Point2D setX(double x) {
        return new ImmutablePoint2D(x, this.getY());
    }

    @Override
    public Point2D setY(double y) {
        return new ImmutablePoint2D(this.getX(), y);
    }

    @Override
    public Point2D scale(double scaleFactor) {
        return new ImmutablePoint2D(this.getX() * scaleFactor, this.getY() * scaleFactor);
    }

    @Override
    public Point2D translate(double ... args) {
        if (Objects.isNull((Object)args) || args.length == 0) {
            return this.copy();
        }
        if (args.length == 1) {
            double newX = this.getX() + args[0];
            double newY = this.getY() + args[0];
            return new ImmutablePoint2D(newX, newY);
        }
        double newX = this.getX() + args[0];
        double newY = this.getY() + args[1];
        return new ImmutablePoint2D(newX, newY);
    }

    @Override
    public List<Point2D> getBounds() {
        return Arrays.asList(new ImmutablePoint2D(this.x, this.x), new ImmutablePoint2D(this.y, this.y));
    }

    @Override
    public Point2D copy() {
        return new ImmutablePoint2D(this.getX(), this.getY());
    }

    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + (int)(Double.doubleToLongBits(this.x) ^ Double.doubleToLongBits(this.x) >>> 32);
        hash = 79 * hash + (int)(Double.doubleToLongBits(this.y) ^ Double.doubleToLongBits(this.y) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutablePoint2D other = (ImmutablePoint2D)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y);
    }
}

