/*
 * Decompiled with CFR 0.152.
 */
package terraml.geometry.impl;

import java.io.Serializable;
import java.util.List;
import terraml.commons.Doubles;
import terraml.commons.Objects;
import terraml.commons.math.Vec2d;
import terraml.commons.math.Vec3d;
import terraml.commons.unit.DimensionUnit;
import terraml.geometry.Plane3D;
import terraml.geometry.ShapeUnit;

public class ImmutablePlane3D
implements Plane3D,
Serializable {
    public final Vec3d _normal;
    public final double _distance;

    public ImmutablePlane3D(Vec3d _normal, double _distance) {
        this._normal = _normal;
        this._distance = _distance;
    }

    public ImmutablePlane3D(Vec3d v0, Vec3d v1, Vec3d v2) {
        Vec3d _let0 = v1.sub(v0);
        Vec3d _let1 = v2.sub(v0);
        Vec3d _cp = _let0.getCrossProduct(_let1);
        this._normal = new Vec3d(_cp);
        this._distance = -1.0 * _cp.getDotProduct(v0);
    }

    private static double _getNorm(double x0, double y0) {
        return new Vec2d(x0, y0).getNorm();
    }

    private static double _getAngle(double x0, double y0) {
        return Math.atan2(x0, y0);
    }

    @Override
    public Plane3D rotate(Vec3d vec3d) {
        double _norm;
        double _angle;
        double _letX = 0.0;
        double _letY = 0.0;
        double _letZ = 0.0;
        if (!Doubles.isEqual((double)this._normal.x, (double)0.0)) {
            _angle = ImmutablePlane3D._getAngle(this._normal.z, this._normal.y);
            _norm = ImmutablePlane3D._getNorm(this._normal.y, this._normal.z);
            _letY = _norm * Math.cos(_angle + vec3d.x);
            _letZ = _norm * Math.sin(_angle + vec3d.x);
        }
        if (!Doubles.isEqual((double)this._normal.y, (double)0.0)) {
            _angle = ImmutablePlane3D._getAngle(this._normal.z, this._normal.x);
            _norm = ImmutablePlane3D._getNorm(this._normal.x, this._normal.z);
            _letX = _norm * Math.cos(_angle + vec3d.y);
            _letZ = _norm * Math.sin(_angle + vec3d.y);
        }
        if (!Doubles.isEqual((double)this._normal.z, (double)0.0)) {
            _angle = ImmutablePlane3D._getAngle(this._normal.x, this._normal.y);
            _norm = ImmutablePlane3D._getNorm(this._normal.y, this._normal.x);
            _letY = _norm * Math.cos(_angle + vec3d.z);
            _letX = _norm * Math.sin(_angle + vec3d.z);
        }
        return new ImmutablePlane3D(new Vec3d(_letX, _letY, _letZ), this._distance);
    }

    @Override
    public double distanceTo(Vec3d vec3d) {
        return this._normal.getDotProduct(vec3d) + this._distance;
    }

    @Override
    public Plane3D getNormalized() {
        double _length = this._normal.getNorm();
        Vec3d _n = this._normal.getNormalized();
        double _nd = this._distance / _length;
        return new ImmutablePlane3D(_n, _nd);
    }

    @Override
    public Vec3d getNormal() {
        return this._normal;
    }

    @Override
    public double getDistance() {
        return this._distance;
    }

    public List getBounds() {
        return null;
    }

    @Override
    public boolean isBounded() {
        return false;
    }

    @Override
    public ImmutablePlane3D copy() {
        return new ImmutablePlane3D(this._normal, this._distance);
    }

    @Override
    public DimensionUnit getDimensionUnit() {
        return DimensionUnit.THREE;
    }

    @Override
    public ShapeUnit getShapeUnit() {
        return ShapeUnit.PLANE;
    }

    @Override
    public Plane3D translate(double ... args) {
        if (Objects.isNull((Object)args)) {
            return this;
        }
        if (args.length == 1) {
            Vec3d v = this.getNormal().translate(args[0]);
            return new ImmutablePlane3D(v, this._distance);
        }
        return this;
    }

    @Override
    public Plane3D scale(double scaleFactor) {
        Vec3d v = this.getNormal().scale(scaleFactor);
        return new ImmutablePlane3D(v, this._distance);
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + java.util.Objects.hashCode(this._normal);
        hash = 47 * hash + (int)(Double.doubleToLongBits(this._distance) ^ Double.doubleToLongBits(this._distance) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutablePlane3D other = (ImmutablePlane3D)obj;
        if (Double.doubleToLongBits(this._distance) != Double.doubleToLongBits(other._distance)) {
            return false;
        }
        return java.util.Objects.equals(this._normal, other._normal);
    }
}

