/*
 * Decompiled with CFR 0.152.
 */
package terraml.geometry.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import terraml.commons.math.Vec3d;
import terraml.commons.unit.DimensionUnit;
import terraml.geometry.Line3D;
import terraml.geometry.Point3D;
import terraml.geometry.ShapeUnit;
import terraml.geometry.impl.ImmutablePoint3D;

public class ImmutableLine3D
implements Line3D,
Serializable {
    private final Point3D _origin;
    private final Vec3d _direction;

    public ImmutableLine3D(Point3D _origin, Vec3d _direction) {
        this._origin = _origin;
        this._direction = _direction;
    }

    public ImmutableLine3D(Point3D _origin, Point3D _toDirection) {
        this(_origin, _toDirection.toVector());
    }

    public ImmutableLine3D(Line3D line3D) {
        this(line3D.getOrigin(), line3D.getDirection());
    }

    @Override
    public boolean skew(Line3D line3D) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double distanceTo(Point3D point3D) {
        Vec3d _v0 = point3D.toVector().sub(this._origin.toVector());
        Vec3d _v1 = this._direction.getCrossProduct(_v0);
        return _v1.getNorm() / this._direction.getNorm();
    }

    @Override
    public double orthogonalDistanceTo(Point3D point3D) {
        Vec3d _cp = this._direction.getCrossProduct(point3D.toVector());
        Vec3d _v0 = _cp.sub(this._direction);
        double _let1 = this._direction.getNorm();
        return _v0.getNorm() / _let1;
    }

    @Override
    public double project(Point3D point3D) {
        Vec3d _v0 = point3D.toVector().sub(this._origin.toVector());
        Vec3d _v1 = this._direction.getCrossProduct(_v0);
        return this._direction.getDotProduct(_v1) / this._direction.getNormSquared();
    }

    @Override
    public Point3D point(double scalar) {
        double _letX = this._origin.getX() + scalar * this._direction.x;
        double _letY = this._origin.getY() + scalar * this._direction.y;
        double _letZ = this._origin.getZ() + scalar * this._direction.z;
        return new ImmutablePoint3D(_letX, _letY, _letZ);
    }

    @Override
    public boolean isParallel(Line3D line3D) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Point3D getOrigin() {
        return this._origin;
    }

    @Override
    public Vec3d getDirection() {
        return this._direction;
    }

    public List getBounds() {
        return null;
    }

    @Override
    public boolean isBounded() {
        return false;
    }

    @Override
    public ImmutableLine3D copy() {
        return new ImmutableLine3D(this._origin, this._direction);
    }

    @Override
    public DimensionUnit getDimensionUnit() {
        return DimensionUnit.THREE;
    }

    @Override
    public ShapeUnit getShapeUnit() {
        return ShapeUnit.LINE;
    }

    @Override
    public Line3D translate(double ... args) {
        Point3D p = this.getOrigin().translate(args);
        return new ImmutableLine3D(p, this._direction);
    }

    @Override
    public Line3D scale(double scaleFactor) {
        Point3D p = this.getOrigin().scale(scaleFactor);
        return new ImmutableLine3D(p, this._direction);
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + Objects.hashCode(this._origin);
        hash = 53 * hash + Objects.hashCode(this._direction);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableLine3D other = (ImmutableLine3D)obj;
        if (!Objects.equals(this._origin, other._origin)) {
            return false;
        }
        return Objects.equals(this._direction, other._direction);
    }
}

