/*
 * Decompiled with CFR 0.152.
 */
package terraml.geometry.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import terraml.commons.unit.DimensionUnit;
import terraml.geometry.Circle2D;
import terraml.geometry.Point2D;
import terraml.geometry.ShapeUnit;
import terraml.geometry.impl.ImmutablePoint2D;

public class ImmutableCircle2D
implements Circle2D,
Serializable {
    private final Point2D _center;
    private final double _radius;

    public ImmutableCircle2D(Point2D _center, double _radius) {
        this._center = _center;
        this._radius = _radius;
    }

    public ImmutableCircle2D(double x, double y, double _radius) {
        this._center = new ImmutablePoint2D(x, y);
        this._radius = _radius;
    }

    public ImmutableCircle2D(Circle2D circle2D) {
        this._center = circle2D.getCenter();
        this._radius = circle2D.getRadius();
    }

    @Override
    public double getArea() {
        return Math.PI * (this._radius * this._radius);
    }

    @Override
    public double angleTo(Circle2D circle2D) {
        return this._center.angleTo(circle2D.getCenter());
    }

    @Override
    public double getWidth() {
        return 2.0 * this._radius;
    }

    @Override
    public double getHeight() {
        return 2.0 * this._radius;
    }

    @Override
    public boolean isBounded() {
        return false;
    }

    @Override
    public List<Point2D> getBounds() {
        double _swX = this._center.getX() - this._radius;
        double _swY = this._center.getY() - this._radius;
        double _neX = this._center.getX() + this._radius;
        double _neY = this._center.getY() + this._radius;
        return Arrays.asList(new ImmutablePoint2D(_swX, _swY), new ImmutablePoint2D(_neX, _neY));
    }

    @Override
    public DimensionUnit getDimensionUnit() {
        return DimensionUnit.TWO;
    }

    @Override
    public ShapeUnit getShapeUnit() {
        return ShapeUnit.CIRCLE;
    }

    @Override
    public Point2D getCenter() {
        return new ImmutablePoint2D(this._center.getX(), this._center.getY());
    }

    @Override
    public double getRadius() {
        return this._radius;
    }

    @Override
    public ImmutableCircle2D copy() {
        return new ImmutableCircle2D(this._center, this._radius);
    }

    @Override
    public Circle2D translate(double ... args) {
        Point2D p0 = this.getCenter().translate(args);
        return new ImmutableCircle2D(p0, this._radius);
    }

    @Override
    public Circle2D scale(double scaleFactor) {
        Point2D p0 = this.getCenter().scale(scaleFactor);
        return new ImmutableCircle2D(p0, this._radius);
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this._center);
        hash = 79 * hash + (int)(Double.doubleToLongBits(this._radius) ^ Double.doubleToLongBits(this._radius) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableCircle2D other = (ImmutableCircle2D)obj;
        if (Double.doubleToLongBits(this._radius) != Double.doubleToLongBits(other._radius)) {
            return false;
        }
        return Objects.equals(this._center, other._center);
    }
}

