/*
 * Decompiled with CFR 0.152.
 */
package terraml.geometry.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import terraml.commons.math.Interval;
import terraml.commons.unit.DimensionUnit;
import terraml.geometry.BBox3D;
import terraml.geometry.Envelope3D;
import terraml.geometry.Point3D;
import terraml.geometry.ShapeUnit;
import terraml.geometry.impl.ImmutablePoint3D;

public class ImmutableBBox3D
implements BBox3D,
Serializable {
    private final Point3D _lowerBound;
    private final Point3D _upperBound;

    public ImmutableBBox3D(Point3D _lowerBound, Point3D _upperBound) {
        Point3D[] _fixedBoundings = ImmutableBBox3D._fixBoundings(_lowerBound, _upperBound);
        this._lowerBound = _fixedBoundings[0];
        this._upperBound = _fixedBoundings[1];
    }

    public ImmutableBBox3D(Point3D _lowerB, double w, double h, double d) {
        this._lowerBound = _lowerB;
        this._upperBound = new ImmutablePoint3D(_lowerB.getX() + w, _lowerB.getY() + h, _lowerB.getZ() + d);
    }

    public ImmutableBBox3D(Envelope3D envelope3D) {
        List<Point3D> _bound = envelope3D.getBounds();
        Point3D[] _fixedBoundings = ImmutableBBox3D._fixBoundings(_bound.get(0), _bound.get(1));
        this._lowerBound = _fixedBoundings[0];
        this._upperBound = _fixedBoundings[1];
    }

    private static Interval[] _axisIntvals(Point3D p0, Point3D p1) {
        Interval _xAxisIntval = new Interval(p0.getX(), p1.getX());
        Interval _yAxisIntval = new Interval(p0.getY(), p1.getY());
        Interval _zAxisIntval = new Interval(p0.getZ(), p1.getZ());
        return new Interval[]{_xAxisIntval, _yAxisIntval, _zAxisIntval};
    }

    private static Point3D[] _fixBoundings(Point3D p0, Point3D p1) {
        Interval[] _intvals = ImmutableBBox3D._axisIntvals(p0, p1);
        Interval _xAxisIntval = _intvals[0];
        Interval _yAxisIntval = _intvals[1];
        Interval _zAxisIntval = _intvals[2];
        ImmutablePoint3D _low = new ImmutablePoint3D(_xAxisIntval.getLeft(), _yAxisIntval.getLeft(), _zAxisIntval.getLeft());
        ImmutablePoint3D _upp = new ImmutablePoint3D(_xAxisIntval.getRight(), _yAxisIntval.getRight(), _zAxisIntval.getRight());
        return new Point3D[]{_low, _upp};
    }

    @Override
    public BBox3D union(BBox3D bBox3D) {
        List<Point3D> _bounds = bBox3D.getBounds();
        Interval[] _intvals0 = ImmutableBBox3D._axisIntvals(this._lowerBound, _bounds.get(0));
        Interval[] _intvals1 = ImmutableBBox3D._axisIntvals(this._upperBound, _bounds.get(1));
        ImmutablePoint3D _low = new ImmutablePoint3D(_intvals0[0].getLeft(), _intvals0[1].getLeft(), _intvals0[2].getLeft());
        ImmutablePoint3D _upp = new ImmutablePoint3D(_intvals1[0].getRight(), _intvals1[1].getRight(), _intvals1[2].getRight());
        return new ImmutableBBox3D(_low, _upp);
    }

    @Override
    public double getVolume() {
        double _w = this.getWidth();
        double _h = this.getHeight();
        double _d = this.getDepth();
        double _const = 1.0;
        return _const * _w * _h * _d;
    }

    @Override
    public Point3D getCentroid() {
        double _dx = this._lowerBound.getX() + this.getWidth() * 0.5;
        double _dy = this._lowerBound.getY() + this.getHeight() * 0.5;
        double _dz = this._lowerBound.getZ() + this.getDepth() * 0.5;
        return new ImmutablePoint3D(_dx, _dy, _dz);
    }

    @Override
    public double getWidth() {
        return this._upperBound.getX() - this._lowerBound.getX();
    }

    @Override
    public double getHeight() {
        return this._upperBound.getY() - this._lowerBound.getY();
    }

    @Override
    public double getDepth() {
        return this._upperBound.getZ() - this._lowerBound.getZ();
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public List<Point3D> getBounds() {
        return Arrays.asList(this._lowerBound, this._upperBound);
    }

    @Override
    public ImmutableBBox3D copy() {
        return new ImmutableBBox3D(this._lowerBound, this._upperBound);
    }

    @Override
    public DimensionUnit getDimensionUnit() {
        return DimensionUnit.THREE;
    }

    @Override
    public ShapeUnit getShapeUnit() {
        return ShapeUnit.ENVELOPE;
    }

    @Override
    public BBox3D scale(double scaleFactor) {
        Point3D p0 = this._lowerBound.scale(scaleFactor);
        Point3D p1 = this._upperBound.scale(scaleFactor);
        return new ImmutableBBox3D(p0, p1);
    }

    @Override
    public BBox3D translate(double ... args) {
        Point3D p0 = this._lowerBound.translate(args);
        Point3D p1 = this._upperBound.translate(args);
        return new ImmutableBBox3D(p0, p1);
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this._lowerBound);
        hash = 53 * hash + Objects.hashCode(this._upperBound);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableBBox3D other = (ImmutableBBox3D)obj;
        if (!Objects.equals(this._lowerBound, other._lowerBound)) {
            return false;
        }
        return Objects.equals(this._upperBound, other._upperBound);
    }
}

