/*
 * Decompiled with CFR 0.152.
 */
package terraml.geometry.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import terraml.commons.math.Interval;
import terraml.commons.unit.DimensionUnit;
import terraml.geometry.BBox2D;
import terraml.geometry.Point2D;
import terraml.geometry.ShapeUnit;
import terraml.geometry.impl.ImmutablePoint2D;

public class ImmutableBBox2D
implements BBox2D,
Serializable {
    private final Point2D _southWest;
    private final Point2D _northEast;

    public ImmutableBBox2D(double x0, double y0, double x1, double y1) {
        this._southWest = new ImmutablePoint2D(x0, y0);
        this._northEast = new ImmutablePoint2D(x1, y1);
    }

    public ImmutableBBox2D(Point2D _southWest, Point2D _northEast) {
        this._southWest = _southWest;
        this._northEast = _northEast;
    }

    public ImmutableBBox2D(BBox2D bBox2D) {
        this._southWest = bBox2D.getSouthWest();
        this._northEast = bBox2D.getNorthEast();
    }

    protected final Point2D[] _fixBoundings(Point2D p0, Point2D p1) {
        Interval _xAxisIntval = new Interval(p0.getX(), p1.getX());
        Interval _yAxisIntval = new Interval(p0.getY(), p1.getY());
        ImmutablePoint2D _sw = new ImmutablePoint2D(_xAxisIntval.getLeft(), _yAxisIntval.getLeft());
        ImmutablePoint2D _ne = new ImmutablePoint2D(_xAxisIntval.getRight(), _yAxisIntval.getRight());
        return new Point2D[]{_sw, _ne};
    }

    @Override
    public ImmutableBBox2D scale(double scaleFactor) {
        Point2D sw = this.getSouthWest().scale(scaleFactor);
        Point2D ne = this.getNorthEast().scale(scaleFactor);
        return new ImmutableBBox2D(sw, ne);
    }

    @Override
    public ImmutableBBox2D translate(double ... args) {
        Point2D sw = this.getSouthWest().translate(args);
        Point2D ne = this.getNorthEast().translate(args);
        return new ImmutableBBox2D(sw, ne);
    }

    @Override
    public List<Point2D> getBounds() {
        return Arrays.asList(this.getSouthWest(), this.getNorthEast());
    }

    @Override
    public ImmutableBBox2D copy() {
        return new ImmutableBBox2D(this.getSouthWest(), this.getNorthEast());
    }

    @Override
    public BBox2D setSouthWest(Point2D point2D) {
        return new ImmutableBBox2D(point2D, this.getNorthEast());
    }

    @Override
    public BBox2D setNorthEast(Point2D point2D) {
        return new ImmutableBBox2D(this.getSouthWest(), point2D);
    }

    @Override
    public Point2D getNorthWest() {
        return new ImmutablePoint2D(this._southWest.getX(), this._southWest.getY() + this.getHeight());
    }

    @Override
    public Point2D getSouthEast() {
        return new ImmutablePoint2D(this._southWest.getX() + this.getWidth(), this._southWest.getY());
    }

    @Override
    public Point2D getNorthEast() {
        return new ImmutablePoint2D(this._northEast);
    }

    @Override
    public Point2D getSouthWest() {
        return new ImmutablePoint2D(this._southWest);
    }

    @Override
    public Point2D getCentroid() {
        double _dx = this._southWest.getX() + this.getWidth() * 0.5;
        double _dy = this._southWest.getY() + this.getHeight() * 0.5;
        return new ImmutablePoint2D(_dx, _dy);
    }

    @Override
    public ShapeUnit getShapeUnit() {
        return ShapeUnit.ENVELOPE;
    }

    @Override
    public DimensionUnit getDimensionUnit() {
        return DimensionUnit.TWO;
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public double getArea() {
        return this.getWidth() * this.getHeight();
    }

    @Override
    public double getHeight() {
        return this._northEast.getY() - this._southWest.getY();
    }

    @Override
    public double getWidth() {
        return this._northEast.getX() - this._southWest.getX();
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this._southWest);
        hash = 67 * hash + Objects.hashCode(this._northEast);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableBBox2D other = (ImmutableBBox2D)obj;
        if (!Objects.equals(this._southWest, other._southWest)) {
            return false;
        }
        return Objects.equals(this._northEast, other._northEast);
    }
}

