/*
 * Decompiled with CFR 0.152.
 */
package terraml.geometry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import terraml.commons.Ints;
import terraml.commons.math.Vec2d;
import terraml.commons.math.Vec3d;
import terraml.geometry.Point2D;
import terraml.geometry.Point3D;
import terraml.geometry.impl.ImmutableBBox2D;
import terraml.geometry.impl.ImmutableBBox3D;
import terraml.geometry.impl.ImmutableCircle2D;
import terraml.geometry.impl.ImmutableLine3D;
import terraml.geometry.impl.ImmutablePlane3D;
import terraml.geometry.impl.ImmutablePoint2D;
import terraml.geometry.impl.ImmutablePoint3D;
import terraml.geometry.impl.ImmutablePolygon2D;
import terraml.geometry.impl.ImmutableSegment2D;
import terraml.geometry.impl.ImmutableSegment3D;
import terraml.geometry.impl.ImmutableSphere3D;

public final class ShapeFactory {
    private ShapeFactory() {
    }

    public static ImmutablePoint2D newImmutablePoint2D(double x, double y) {
        return new ImmutablePoint2D(x, y);
    }

    public static ImmutablePoint2D newImmutablePoint2D(Vec2d vec2d) {
        return new ImmutablePoint2D(vec2d.getX(), vec2d.getY());
    }

    public static final ImmutablePoint2D newImmutablePoint2D(double[] array) {
        if (Ints.isEqual((int)array.length, (int)2)) {
            double[] _refArr = array;
            double _x = _refArr[0];
            double _y = _refArr[1];
            return new ImmutablePoint2D(_x, _y);
        }
        throw new IllegalArgumentException("{acceptable format {x, y}");
    }

    public static ImmutablePoint3D newImmutablePoint3D(double x, double y, double z) {
        return new ImmutablePoint3D(x, y, z);
    }

    public static ImmutablePoint3D newImmutablePoint3D(Vec3d vec3d) {
        return new ImmutablePoint3D(vec3d.getX(), vec3d.getY(), vec3d.getZ());
    }

    public static final ImmutablePoint3D newImmutablePoint3D(double[] array) {
        if (Ints.isEqual((int)array.length, (int)3)) {
            double[] _refArr = array;
            double _x = _refArr[0];
            double _y = _refArr[1];
            double _z = _refArr[2];
            return new ImmutablePoint3D(_x, _y, _z);
        }
        throw new IllegalArgumentException("acceptable format: {x, y, z}");
    }

    public static final ImmutableBBox2D newImmutableBBox2D(Point2D sw, Point2D ne) {
        return new ImmutableBBox2D(sw, ne);
    }

    public static final ImmutableBBox2D newImmutableBBox2D(double[] array) {
        if (Ints.isEqual((int)array.length, (int)4)) {
            double[] arr = array;
            ImmutablePoint2D p0 = new ImmutablePoint2D(arr[0], arr[1]);
            ImmutablePoint2D p1 = new ImmutablePoint2D(arr[2], arr[3]);
            return new ImmutableBBox2D(p0, p1);
        }
        throw new IllegalArgumentException("acceptable format: {x0, y0, x1, y1}");
    }

    public static final ImmutableBBox2D newImmutableBBox2D(double[][] array) {
        double[][] arr;
        if (Ints.isEqual((int)array.length, (int)2) && Ints.isEqual((int)(arr = array)[0].length, (int)2) && Ints.isEqual((int)arr[1].length, (int)2)) {
            ImmutablePoint2D p0 = new ImmutablePoint2D(arr[0][0], arr[0][1]);
            ImmutablePoint2D p1 = new ImmutablePoint2D(arr[1][0], arr[1][1]);
            return new ImmutableBBox2D(p0, p1);
        }
        throw new IllegalArgumentException("acceptable format: [{x0, y0}, {x1, y1}]");
    }

    public static final ImmutableCircle2D newImmutableCircle2D(Point2D center, double r) {
        return new ImmutableCircle2D(center, r);
    }

    public static final ImmutableCircle2D newImmutableCircle2D(double[] array) {
        if (Ints.isEqual((int)array.length, (int)3)) {
            double[] _refArr = array;
            ImmutablePoint2D _center = new ImmutablePoint2D(_refArr[0], _refArr[1]);
            double _radius = _refArr[2];
            return new ImmutableCircle2D(_center, _radius);
        }
        throw new IllegalArgumentException("acceptable format: {x, y, radius}");
    }

    public static final ImmutableSegment2D newImmutableSegment2D(Point2D source, Point2D target) {
        return new ImmutableSegment2D(source, target);
    }

    public static final ImmutableSegment2D newImmutableSegment2D(double[] array) {
        if (Ints.isEqual((int)array.length, (int)4)) {
            double[] _refArr = array;
            ImmutablePoint2D _src = new ImmutablePoint2D(_refArr[0], _refArr[1]);
            ImmutablePoint2D _trg = new ImmutablePoint2D(_refArr[2], _refArr[3]);
            return new ImmutableSegment2D(_src, _trg);
        }
        throw new IllegalArgumentException("acceptable format: {x0, y0, x1, y1}");
    }

    public static final ImmutableSegment2D newImmutableSegment2D(double[][] array) {
        double[][] _refArr;
        if (Ints.isEqual((int)array.length, (int)2) && Ints.isEqual((int)(_refArr = array)[0].length, (int)2) && Ints.isEqual((int)_refArr[1].length, (int)2)) {
            ImmutablePoint2D _src = new ImmutablePoint2D(_refArr[0][0], _refArr[0][1]);
            ImmutablePoint2D _trg = new ImmutablePoint2D(_refArr[1][0], _refArr[1][1]);
            return new ImmutableSegment2D(_src, _trg);
        }
        throw new IllegalArgumentException("acceptable format: [{x0, y0}, {x1, y1}]");
    }

    public static final ImmutablePolygon2D newImmutablePolygon2D(List<Point2D> list) {
        return new ImmutablePolygon2D(list);
    }

    public static final ImmutablePolygon2D newImmutablePolygon2D(Point2D ... list) {
        return new ImmutablePolygon2D(Arrays.asList(list));
    }

    public static final ImmutablePolygon2D newImmutablePolygon2D(double[][] array) {
        if (Ints.isEqual((int)array.length, (int)4)) {
            ArrayList<Point2D> newVertices = new ArrayList<Point2D>();
            for (int i = 0; i < 4; ++i) {
                double[] current = array[i];
                if (!Ints.isEqual((int)current.length, (int)2)) {
                    throw new IllegalArgumentException("acceptable format: [{x0, y0}, {x1, y1} ..., {xn, yn}]");
                }
                newVertices.add(new ImmutablePoint2D(current[0], current[1]));
            }
            return new ImmutablePolygon2D(newVertices);
        }
        throw new IllegalArgumentException("acceptable format: [{x0, y0}, {x1, y1} ..., {xn, yn}]");
    }

    public static final ImmutableBBox3D newImmutableBBox3D(Point3D p0, Point3D p1) {
        return new ImmutableBBox3D(p0, p1);
    }

    public static final ImmutableBBox3D newImmutableBBox3D(Point3D p0, double w, double h, double d) {
        return new ImmutableBBox3D(p0, w, h, d);
    }

    public static final ImmutableBBox3D newImmutableBBox3D(double[][] array) {
        if (Ints.isEqual((int)array.length, (int)2)) {
            double[] _p0 = array[0];
            double[] _p1 = array[1];
            if (Ints.isEqual((int)_p0.length, (int)3) && Ints.isEqual((int)_p1.length, (int)3)) {
                ImmutablePoint3D _low = new ImmutablePoint3D(_p0[0], _p0[1], _p0[2]);
                ImmutablePoint3D _upp = new ImmutablePoint3D(_p1[0], _p1[1], _p1[2]);
                return new ImmutableBBox3D(_low, _upp);
            }
        }
        throw new IllegalArgumentException("acceptable format: [{x0, y0, z0}, {x1, y1, z1}]");
    }

    public static final ImmutableLine3D newImmutableLine3D(Point3D point3D, Vec3d vec3d) {
        return new ImmutableLine3D(point3D, vec3d);
    }

    public static final ImmutableLine3D newImmutableLine3D(Point3D point3D, Point3D dirr) {
        return new ImmutableLine3D(point3D, dirr);
    }

    public static final ImmutableLine3D newImmutableLine3D(double[][] array) {
        if (Ints.isEqual((int)array.length, (int)2)) {
            double[] _p0 = array[0];
            double[] _p1 = array[1];
            if (Ints.isEqual((int)_p0.length, (int)3) && Ints.isEqual((int)_p1.length, (int)3)) {
                ImmutablePoint3D _low = new ImmutablePoint3D(_p0[0], _p0[1], _p0[2]);
                Vec3d _dirr = new Vec3d(_p1[0], _p1[1], _p1[2]);
                return new ImmutableLine3D((Point3D)_low, _dirr);
            }
        }
        throw new IllegalArgumentException("acceptable format: [{x0, y0, z0}, {x1, y1, z1}]");
    }

    public static final ImmutablePlane3D newImmutablePlane3D(Vec3d vec3d, double offset) {
        return new ImmutablePlane3D(vec3d, offset);
    }

    public static final ImmutablePlane3D newImmutablePlane3D(Vec3d v0, Vec3d v1, Vec3d v2) {
        return new ImmutablePlane3D(v0, v1, v2);
    }

    public static final ImmutableSegment3D newImmutableSegment3D(Point3D src, Point3D tar) {
        return new ImmutableSegment3D(src, tar);
    }

    public static final ImmutableSegment3D newImmutableSegment3D(double[][] array) {
        if (Ints.isEqual((int)array.length, (int)2)) {
            double[] _p0 = array[0];
            double[] _p1 = array[1];
            if (Ints.isEqual((int)_p0.length, (int)3) && Ints.isEqual((int)_p1.length, (int)3)) {
                ImmutablePoint3D _src = new ImmutablePoint3D(_p0[0], _p0[1], _p0[2]);
                ImmutablePoint3D _tar = new ImmutablePoint3D(_p1[0], _p1[1], _p1[2]);
                return new ImmutableSegment3D(_src, _tar);
            }
        }
        throw new IllegalArgumentException("acceptable format: [{x0, y0, z0}, {x1, y1, z1}]");
    }

    public static final ImmutableSphere3D newImmutableSphere3D(Point3D center, double radius) {
        return new ImmutableSphere3D(center, radius);
    }
}

