/*
 * Decompiled with CFR 0.152.
 */
package terraml.geometry;

import java.util.Arrays;
import java.util.List;
import terraml.commons.Doubles;
import terraml.commons.math.Interval;
import terraml.commons.math.Vec2d;
import terraml.commons.math.Vec3d;
import terraml.geometry.Circle2D;
import terraml.geometry.Envelope2D;
import terraml.geometry.Envelope3D;
import terraml.geometry.Line3D;
import terraml.geometry.Plane3D;
import terraml.geometry.Point2D;
import terraml.geometry.Point3D;
import terraml.geometry.Polygon2D;
import terraml.geometry.Segment2D;
import terraml.geometry.Segment3D;
import terraml.geometry.Sphere3D;
import terraml.geometry.impl.ImmutablePoint2D;
import terraml.geometry.impl.ImmutableSegment2D;

public final class Intersector {
    private Intersector() {
    }

    public static boolean contains(Polygon2D _container, Point2D _p0) {
        Point2D _currentP = _container.getVertices().get(0);
        int _length = _container.getVerticesCount();
        int _rayCross = 0;
        for (int t = 1; t < _length; ++t) {
            boolean _dy1;
            boolean _dy0 = _currentP.getY() <= _p0.getY() && _p0.getY() < _container.getVertices().get(t).getY();
            boolean bl = _dy1 = _container.getVertices().get(t).getY() <= _p0.getY() && _p0.getY() < _currentP.getY();
            if (_dy0 || _dy1) {
                double crs = (_container.getVertices().get(t).getX() - _currentP.getX()) * (_p0.getY() - _currentP.getY()) / (_container.getVertices().get(t).getY() - _currentP.getY()) + _currentP.getX();
                if (_p0.getX() < crs) {
                    ++_rayCross;
                }
            }
            _currentP = _container.getVertices().get(t);
        }
        return _rayCross % 2 == 1;
    }

    public static boolean contains(Circle2D _container, Point2D _p0) {
        Vec2d _v0 = _container.getCenter().toVector();
        Vec2d _v1 = _p0.toVector();
        double _letX = _v0.distanceTo(_v1);
        return Doubles.isSmallerEqual((double)_letX, (double)_container.getRadius());
    }

    public static boolean contains(Envelope2D _container, Point2D _point2) {
        Interval _intvalX = Intersector.getXInterval(_container);
        Interval _intvalY = Intersector.getYInterval(_container);
        return _intvalX.inRange(_point2.getX()) && _intvalY.inRange(_point2.getY());
    }

    public static boolean contains(Envelope3D _container, Point3D _point3) {
        Interval _intvalX = Intersector.getXInterval(_container);
        Interval _intvalY = Intersector.getYInterval(_container);
        Interval _intvalZ = Intersector.getZInterval(_container);
        return _intvalX.inRange(_point3.getX()) && _intvalY.inRange(_point3.getY()) && _intvalZ.inRange(_point3.getZ());
    }

    public static boolean contains(Sphere3D _container, Point3D _p0) {
        return Doubles.isSmallerEqual((double)_container.getCenter().distanceTo(_p0), (double)_container.getRadius());
    }

    public static Vec3d nearestPoint(Line3D _container, Point3D _p0) {
        Vec3d _v0 = _p0.toVector();
        Vec3d _v1 = _container.getOrigin().toVector();
        Vec3d _v2 = _v0.sub(_v1);
        double _let0 = _v2.getDotProduct(_container.getDirection());
        double _let1 = _container.getDirection().getNorm();
        Vec3d _v3 = _container.getDirection().scale(_let0 / _let1);
        return _v1.add(_v3);
    }

    private static boolean _overlap(Circle2D _container, Circle2D _circle2) {
        Vec2d _v0 = _container.getCenter().toVector();
        Vec2d _v1 = _circle2.getCenter().toVector();
        double _let0 = _v0.distanceTo(_v1);
        double _let1 = _container.getRadius() - _circle2.getRadius();
        return Doubles.isSmallerEqual((double)_let0, (double)_let1);
    }

    public static boolean contains(Circle2D _container, Circle2D _circle2) {
        return Intersector._overlap(_container, _circle2);
    }

    public static boolean within(Circle2D _circle2, Circle2D _container) {
        return Intersector._overlap(_container, _circle2);
    }

    private static boolean _intersects(Circle2D shape0, Circle2D shape1) {
        if (Intersector._overlap(shape0, shape1) || Intersector._overlap(shape1, shape0)) {
            return false;
        }
        Vec2d _v0 = shape0.getCenter().toVector();
        Vec2d _v1 = shape1.getCenter().toVector();
        double _let0 = _v0.distanceTo(_v1);
        double _let1 = shape0.getRadius() + shape1.getRadius();
        return Doubles.isSmallerEqual((double)_let0, (double)_let1);
    }

    public static boolean intersects(Circle2D shape0, Circle2D shape1) {
        return Intersector._intersects(shape0, shape1);
    }

    private static boolean _contains(Circle2D _container, Envelope2D _env2) {
        if (Intersector.contains(_container, _env2.getCentroid())) {
            return true;
        }
        boolean _allBoundsIn = true;
        List<Point2D> _cornerList = Intersector.exportCorners(_env2);
        for (Point2D _each : _cornerList) {
            if (Intersector.contains(_container, _each)) continue;
            _allBoundsIn = false;
            break;
        }
        return _allBoundsIn;
    }

    public static boolean contains(Circle2D containerShape, Envelope2D shape) {
        return Intersector._contains(containerShape, shape);
    }

    private static boolean _contains(Circle2D _container, Segment2D _segment2) {
        boolean _let0 = Intersector.contains(_container, _segment2.getSource());
        if (!_let0) {
            return false;
        }
        boolean _let1 = Intersector.contains(_container, _segment2.getTarget());
        return _let0 && _let1;
    }

    public static boolean contains(Circle2D _container, Segment2D _segment2) {
        return Intersector._contains(_container, _segment2);
    }

    private static boolean _contains(Envelope2D _container, Circle2D _circle2) {
        return _circle2.getBounds().stream().noneMatch(_eachB -> !Intersector.contains(_container, _eachB));
    }

    public static boolean contains(Envelope2D _container, Circle2D _circle2) {
        return Intersector._contains(_container, _circle2);
    }

    private static double _determine(double _ax, double _ls, double _gr) {
        if (Doubles.isSmaller((double)_ax, (double)_ls)) {
            return _ls;
        }
        if (Doubles.isGreater((double)_ax, (double)_gr)) {
            return _gr;
        }
        return _ax;
    }

    private static boolean _intersects(Envelope2D _env2, Circle2D _circle2) {
        double _letX = _circle2.getCenter().getX();
        double _letY = _circle2.getCenter().getY();
        Point2D _lowerBnd = _env2.getSouthWest();
        Point2D _upperBnd = _env2.getNorthEast();
        _letX = Intersector._determine(_letX, _lowerBnd.getX(), _upperBnd.getX());
        _letY = Intersector._determine(_letY, _lowerBnd.getY(), _upperBnd.getY());
        double _dstX = _letX - _circle2.getCenter().getX();
        double _dstY = _letY - _circle2.getCenter().getY();
        return Doubles.isSmallerEqual((double)(_dstX * _dstX + _dstY * _dstY), (double)(_circle2.getRadius() * _circle2.getRadius()));
    }

    public static boolean intersects(Envelope2D shape0, Circle2D shape1) {
        return Intersector._intersects(shape0, shape1);
    }

    private static boolean _contains(Envelope2D _container, Envelope2D _env2) {
        Interval _env0X = Intersector.getXInterval(_container);
        Interval _env0Y = Intersector.getYInterval(_container);
        Interval _env1X = Intersector.getXInterval(_env2);
        Interval _env1Y = Intersector.getYInterval(_env2);
        return _env0X.intersects(_env1X) && _env0Y.intersects(_env1Y);
    }

    public static boolean contains(Envelope2D containerShape, Envelope2D _env2) {
        return Intersector._contains(containerShape, _env2);
    }

    public static boolean within(Envelope2D _env2, Envelope2D containerShape) {
        return Intersector._contains(containerShape, _env2);
    }

    private static boolean _intersects(Envelope2D _env0, Envelope2D _env1) {
        Interval _env0X = Intersector.getXInterval(_env0);
        Interval _env0Y = Intersector.getYInterval(_env0);
        Interval _env1X = Intersector.getXInterval(_env1);
        Interval _env1Y = Intersector.getYInterval(_env1);
        return _env0X.intersects(_env1X) && _env0Y.intersects(_env1Y);
    }

    public static boolean intersects(Envelope2D _env0, Envelope2D _env1) {
        return Intersector._intersects(_env0, _env1);
    }

    private static boolean _contains(Envelope2D containerShape, Segment2D shape) {
        return Intersector.contains(containerShape, shape.getSource()) && Intersector.contains(containerShape, shape.getTarget());
    }

    public static boolean contains(Envelope2D containerShape, Segment2D shape) {
        return Intersector._contains(containerShape, shape);
    }

    private static boolean _contains(Envelope3D _container, Envelope3D _env3) {
        List<Point3D> _bounds = _env3.getBounds();
        return _bounds.stream().noneMatch(_eachB -> !Intersector.contains(_container, _eachB));
    }

    public static boolean within(Envelope3D shape, Envelope3D containerShape) {
        return Intersector._contains(containerShape, shape);
    }

    public static boolean contains(Envelope3D containerShape, Envelope3D shape) {
        return Intersector._contains(containerShape, shape);
    }

    private static boolean _intersects(Envelope3D shape0, Envelope3D shape1) {
        Interval[] _intValXYZ0 = Intersector.getXYZInterval(shape0);
        Interval[] _intValXYZ1 = Intersector.getXYZInterval(shape1);
        for (int i = 0; i < 3; ++i) {
            if (_intValXYZ0[i].intersects(_intValXYZ1[i])) continue;
            return false;
        }
        return false;
    }

    private static boolean _intersects2(Envelope3D shape0, Envelope3D shape1) {
        double _letX = shape1.getCentroid().getX() - shape0.getCentroid().getX();
        double _letW = shape0.getWidth() / 2.0 + shape1.getWidth() / 2.0;
        double _letY = shape1.getCentroid().getY() - shape0.getCentroid().getY();
        double _letH = shape0.getHeight() / 2.0 + shape1.getHeight() / 2.0;
        double _letZ = shape1.getCentroid().getZ() - shape0.getCentroid().getZ();
        double _letD = shape0.getDepth() / 2.0 + shape1.getDepth() / 2.0;
        _letX = Math.abs(_letX);
        _letY = Math.abs(_letY);
        _letZ = Math.abs(_letZ);
        return Doubles.isSmallerEqual((double)_letX, (double)_letW) && Doubles.isSmallerEqual((double)_letY, (double)_letH) && Doubles.isSmallerEqual((double)_letZ, (double)_letD);
    }

    public static boolean intersects(Envelope3D shape0, Envelope3D shape1) {
        return Intersector._intersects2(shape0, shape1);
    }

    private static boolean _contains(Envelope3D containerShape, Segment3D shape) {
        Point3D[] _srcTar;
        for (Point3D _eachP : _srcTar = new Point3D[]{shape.getSource(), shape.getTarget()}) {
            if (Intersector.contains(containerShape, _eachP)) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(Envelope3D containerShape, Segment3D shape) {
        return Intersector._contains(containerShape, shape);
    }

    private static boolean _intersects(Segment2D _seg2, Circle2D _circle2) {
        double _ny;
        double _nx;
        Vec2d _v0 = _seg2.getSource().toVector();
        Vec2d _v1 = _seg2.getTarget().toVector();
        Vec2d _v2 = _circle2.getCenter().toVector();
        Vec2d _v3 = _v1.sub(_v0);
        Vec2d _v4 = _v2.sub(_v0);
        double _let0 = _v3.getNorm();
        double _let1 = _v4.getDotProduct(_v3.getNormalized());
        if (Doubles.isSmallerEqual((double)_let1, (double)0.0)) {
            _nx = _v0.getX();
            _ny = _v0.getY();
        } else if (Doubles.isGreaterEqual((double)_let1, (double)_let0)) {
            _nx = _v1.getX();
            _ny = _v1.getY();
        } else {
            Vec2d _v5 = _v0.scale(_let1);
            _nx = _v5.x + _v0.x;
            _ny = _v5.y + _v0.y;
        }
        double _letX = _v2.x - _nx;
        double _letY = _v2.y - _ny;
        double _dst = _letX * _letX + _letY * _letY;
        return Doubles.isSmallerEqual((double)_dst, (double)(_circle2.getRadius() * _circle2.getRadius()));
    }

    public static boolean intersects(Segment2D shape0, Circle2D shape1) {
        return Intersector._intersects(shape0, shape1);
    }

    private static boolean _intersects(Segment2D _seg2, Envelope2D _env2) {
        if (Intersector.contains(_env2, _seg2)) {
            return false;
        }
        double p1x = _seg2.getSource().getX();
        double p2x = _seg2.getTarget().getX();
        double minX = p1x;
        double maxX = p2x;
        if (Doubles.isGreater((double)p1x, (double)p2x)) {
            minX = p2x;
            maxX = p1x;
        }
        double rectMinX = _env2.getSouthWest().getX();
        double rectMaxX = _env2.getNorthEast().getX();
        if (Doubles.isGreater((double)maxX, (double)rectMaxX)) {
            maxX = rectMaxX;
        }
        if (Doubles.isSmaller((double)minX, (double)rectMinX)) {
            minX = rectMinX;
        }
        if (Doubles.isGreater((double)minX, (double)maxX)) {
            return false;
        }
        double p1y = _seg2.getSource().getY();
        double p2y = _seg2.getTarget().getY();
        double minY = p1y;
        double maxY = p2y;
        double _dx = p2x - p1x;
        if (Doubles.isGreater((double)Math.abs(_dx), (double)1.0E-8)) {
            double _let0 = (p2y - p1y) / _dx;
            double _let1 = p1y - _let0 * p1x;
            minY = _let0 * minX + _let1;
            maxY = _let0 * maxX + _let1;
        }
        if (Doubles.isGreater((double)minY, (double)maxY)) {
            double tmp = maxY;
            maxY = minY;
            minY = tmp;
        }
        double rectMinY = _env2.getSouthWest().getY();
        double rectMaxY = _env2.getNorthEast().getY();
        if (Doubles.isGreater((double)maxY, (double)rectMaxY)) {
            maxY = rectMaxY;
        }
        if (Doubles.isSmaller((double)minY, (double)rectMinY)) {
            minY = rectMinY;
        }
        return !Doubles.isGreater((double)minY, (double)maxY);
    }

    public static boolean intersects(Segment2D shape0, Envelope2D shape1) {
        return Intersector._intersects(shape0, shape1);
    }

    private static boolean _intersects(Segment2D shape0, Segment2D shape1) {
        double v0x = shape0.getSource().getX();
        double v0y = shape0.getSource().getY();
        double v1x = shape0.getTarget().getX();
        double v1y = shape0.getTarget().getY();
        double v2x = shape1.getSource().getX();
        double v2y = shape1.getSource().getY();
        double v3x = shape1.getTarget().getX();
        double v3y = shape1.getTarget().getY();
        double Qx = v1x - v0x;
        double Qy = v1y - v0y;
        double Wx = v3x - v2x;
        double Wy = v3y - v2y;
        double dx = v0x - v2x;
        double dy = v0y - v2y;
        double d = -Wx * Qy + Qx * Wy;
        double Zr = (-Qy * dx + Qx * dy) / d;
        double Zt = (Wx * dy - Wy * dx) / d;
        return Zr >= 0.0 && Zr <= 1.0 && Zt >= 0.0 && Zt <= 1.0;
    }

    public static boolean intersects(Segment2D shape0, Segment2D shape1) {
        return Intersector._intersects(shape0, shape1);
    }

    private static boolean _intersects(Segment3D _seg3, Plane3D _pl3) {
        Vec3d _v0 = _seg3.getSource().toVector();
        Vec3d _v1 = _seg3.getTarget().toVector();
        Vec3d _v2 = _v1.sub(_v0);
        double _let0 = _v2.getDotProduct(_pl3.getNormal());
        double _let1 = _v0.getDotProduct(_pl3.getNormal()) + _pl3.getDistance();
        double _let2 = -1.0 * (_let1 / _let0);
        return !Doubles.isSmaller((double)_let2, (double)0.0) && !Doubles.isGreater((double)_let2, (double)1.0);
    }

    public static boolean intersects(Segment3D shape0, Plane3D shape1) {
        return Intersector._intersects(shape0, shape1);
    }

    private static boolean _intersects(Sphere3D _sph3, Line3D _ln3) {
        Vec3d _v0 = _sph3.getCenter().toVector();
        double _let0 = _v0.distanceTo(Intersector.nearestPoint(_ln3, _sph3.getCenter()));
        return Doubles.isSmallerEqual((double)_let0, (double)_sph3.getRadius());
    }

    public static boolean intersects(Sphere3D shape0, Line3D shape1) {
        return Intersector._intersects(shape0, shape1);
    }

    private static boolean _intersects(Sphere3D _sph3, Plane3D _pla3) {
        Vec3d _v0 = _sph3.getCenter().toVector();
        double _let0 = _pla3.getNormal().getDotProduct(_v0);
        return Doubles.isSmallerEqual((double)_let0, (double)_sph3.getRadius());
    }

    public static boolean intersects(Sphere3D shape0, Plane3D shape1) {
        return Intersector._intersects(shape0, shape1);
    }

    public static List<Segment2D> exportSegments(Envelope2D _env) {
        return Arrays.asList(new ImmutableSegment2D(_env.getSouthWest(), _env.getSouthEast()), new ImmutableSegment2D(_env.getSouthWest(), _env.getNorthWest()), new ImmutableSegment2D(_env.getSouthEast(), _env.getNorthEast()), new ImmutableSegment2D(_env.getNorthWest(), _env.getNorthEast()));
    }

    public static List<Point2D> exportCorners(Envelope2D _env) {
        return Arrays.asList(new ImmutablePoint2D(_env.getNorthEast()), new ImmutablePoint2D(_env.getSouthEast()), new ImmutablePoint2D(_env.getSouthWest()), new ImmutablePoint2D(_env.getNorthWest()));
    }

    public static Interval getXInterval(Envelope2D _env2) {
        return new Interval(_env2.getSouthWest().getX(), _env2.getNorthEast().getX());
    }

    public static Interval getYInterval(Envelope2D _env2) {
        return new Interval(_env2.getSouthWest().getY(), _env2.getNorthEast().getY());
    }

    public static Interval[] getXYInterval(Envelope2D _env2) {
        return new Interval[]{Intersector.getXInterval(_env2), Intersector.getYInterval(_env2)};
    }

    public static Interval getXInterval(Envelope3D _env3) {
        List<Point3D> _bounds = _env3.getBounds();
        return new Interval(_bounds.get(0).getX(), _bounds.get(1).getX());
    }

    public static Interval getYInterval(Envelope3D _env3) {
        List<Point3D> _bounds = _env3.getBounds();
        return new Interval(_bounds.get(0).getY(), _bounds.get(1).getY());
    }

    public static Interval getZInterval(Envelope3D _env3) {
        List<Point3D> _bounds = _env3.getBounds();
        return new Interval(_bounds.get(0).getZ(), _bounds.get(1).getZ());
    }

    public static Interval[] getXYZInterval(Envelope3D _env3) {
        return new Interval[]{Intersector.getXInterval(_env3), Intersector.getYInterval(_env3), Intersector.getZInterval(_env3)};
    }

    public static double getMinimumX(Envelope2D _env2) {
        return Intersector.getXInterval((Envelope2D)_env2).left;
    }

    public static double getMinimumX(Envelope3D _env3) {
        return Intersector.getXInterval((Envelope3D)_env3).left;
    }

    public static double getMinimumY(Envelope2D _env2) {
        return Intersector.getYInterval((Envelope2D)_env2).left;
    }

    public static double getMinimumY(Envelope3D _env3) {
        return Intersector.getYInterval((Envelope3D)_env3).left;
    }

    public static double getMaximumX(Envelope2D _env2) {
        return Intersector.getXInterval((Envelope2D)_env2).right;
    }

    public static double getMaximumX(Envelope3D _env3) {
        return Intersector.getXInterval((Envelope3D)_env3).right;
    }

    public static double getMaximumY(Envelope2D _env2) {
        return Intersector.getYInterval((Envelope2D)_env2).right;
    }

    public static double getMaximumY(Envelope3D _env3) {
        return Intersector.getYInterval((Envelope3D)_env3).right;
    }

    public static double getMinimumZ(Envelope3D _env3) {
        return Intersector.getZInterval((Envelope3D)_env3).left;
    }

    public static double getMaximumZ(Envelope3D _env3) {
        return Intersector.getZInterval((Envelope3D)_env3).right;
    }
}

