/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This file is part of terraml-geometry project.
 *
 * This file incorporates work covered by
 * the following copyright and permission notices:
 *
 * Copyright (C) 2018 Terra Software Informatics LLC. | info [at] terrayazilim [dot] com [dot] tr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package terraml.geometry;

import java.util.List;
import terraml.commons.annotation.File;
import terraml.commons.math.Vec3d;

/**
 * @author M.Çağrı Tepebaşılı - cagritepebasili [at] protonmail [dot] com
 * @version 1.0.0-SNAPSHOT
 */
@File(
        fileName = "Point3D.java",
        packageName = "terraml.geometry",
        projectName = "terraml-geometry"
)
public interface Point3D extends Geometry {

    /**
     * @param Point3D
     * @return
     */
    public boolean isParallel(Point3D _p1);

    /**
     * @param Point3D
     * @return
     */
    public boolean isAntiParallel(Point3D _p1);

    /**
     * @param point3D
     * @return
     */
    public double cosine(Point3D point3D);

    /**
     * @param point3D
     * @return
     */
    public double distanceTo(Point3D point3D);

    /**
     * @param point3D
     * @return
     */
    public double angleTo(Point3D point3D);

    /**
     * @return
     */
    public double getX();

    /**
     * @return
     */
    public double getY();

    /**
     * @return
     */
    public double getZ();

    /**
     * @return
     */
    public double[] toArray();

    /**
     * @return
     */
    public Vec3d toVector();

    @Override
    public Point3D copy();

    @Override
    public boolean isBounded();

    @Override
    public List<Point3D> getBounds();

    @Override
    public Point3D translate(double... args);

    @Override
    public Point3D scale(double scaleFactor);

}
