/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This file is part of terraml-geometry project.
 *
 * This file incorporates work covered by
 * the following copyright and permission notices:
 *
 * Copyright (C) 2018 Terra Software Informatics LLC. | info [at] terrayazilim [dot] com [dot] tr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package terraml.geometry;

import java.util.List;
import terraml.commons.annotation.File;
import terraml.commons.math.Vec2d;
import terraml.commons.unit.DirectionUnit;

/**
 * @author M.Çağrı Tepebaşılı - cagritepebasili [at] protonmail [dot] com
 * @version 1.0.0-SNAPSHOT
 */
@File(
        fileName = "Point2D.java",
        packageName = "terraml.geometry",
        projectName = "terraml-geometry"
)
public interface Point2D extends Geometry {

    /**
     * @param Point2D
     * @param Point2D
     * @return
     */
    public int ccw(Point2D _p0, Point2D _p1);

    /**
     * @param Point2D
     * @param Point2D
     * @return
     */
    public boolean isBetween(Point2D _p0, Point2D _p1);

    /**
     * @param point2D
     * @return DirectionUnit. However if given Point2D's are equal, then it
     *         returns null.
     */
    public DirectionUnit directionTo(Point2D point2D);

    /**
     * @param Point2D
     * @param Point2D
     * @return
     */
    public boolean isCollinearWith(Point2D p0, Point2D p1);

    /**
     * @param List<Point2D>
     * @return
     */
    public Point2D centroidOf(List<Point2D> _ptrList);

    /**
     * @return
     */
    public double getX();

    /**
     * @return
     */
    public double getY();

    /**
     * @param double
     * @return
     */
    public Point2D setX(double x);

    /**
     * @param double
     * @return
     */
    public Point2D setY(double y);

    /**
     * @param Point2D
     * @return angle thru given Point2D range of -180 and +180 as degree.
     */
    public double angleTo(Point2D point2D);

    /**
     * @param Point2D
     * @return
     */
    public double distanceTo(Point2D point2D);

    /**
     * @return
     */
    public double[] toArray();

    /**
     * @return
     */
    public Vec2d toVector();

    @Override
    public Point2D scale(double scaleFactor);

    @Override
    public Point2D translate(double... args);

    @Override
    public List<Point2D> getBounds();

    @Override
    public boolean isBounded();

    @Override
    public Point2D copy();
}
