/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This file is part of terraml-geometry project.
 *
 * This file incorporates work covered by
 * the following copyright and permission notices:
 *
 * Copyright (C) 2018 Terra Software Informatics LLC. | info [at] terrayazilim [dot] com [dot] tr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package terraml.geometry;

import java.util.List;
import terraml.commons.annotation.File;
import terraml.commons.unit.DimensionUnit;

/**
 * @author M.Çağrı Tepebaşılı - cagritepebasili [at] protonmail [dot] com
 * @version 1.0.0-SNAPSHOT
 */
@File(
        fileName = "Circle2D.java",
        packageName = "terraml.geometry",
        projectName = "terraml-geometry"
)
public interface Circle2D extends Shape {

    /**
     * @return
     */
    public double getArea();

    /**
     * @param circle2D
     * @return
     */
    public double angleTo(Circle2D circle2D);

    /**
     * @return
     */
    public Point2D getCenter();

    /**
     * @return
     */
    public double getRadius();

    /**
     * @return
     */
    public double getWidth();

    /**
     * @return
     */
    public double getHeight();

    @Override
    public Circle2D copy();

    @Override
    public boolean isBounded();

    @Override
    public List<Point2D> getBounds();

    @Override
    public Circle2D translate(double... args);

    @Override
    public Circle2D scale(double scaleFactor);

    @Override
    public DimensionUnit getDimensionUnit();

    @Override
    public ShapeUnit getShapeUnit();
}
