/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This file is part of terraml-geometry project.
 *
 * This file incorporates work covered by
 * the following copyright and permission notices:
 *
 * Copyright (C) 2018 Terra Software Informatics LLC. | info [at] terrayazilim [dot] com [dot] tr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package terraml.geometry;

import java.util.List;
import terraml.commons.annotation.File;
import terraml.commons.unit.DimensionUnit;

/**
 * @author M.Çağrı Tepebaşılı - cagritepebasili [at] protonmail [dot] com
 * @version 1.0.0-SNAPSHOT
 */
@File(
        fileName = "BBox2D.java",
        packageName = "terraml.geometry",
        projectName = "terraml-geometry"
)
public interface BBox2D extends Envelope2D {

    @Override
    public ShapeUnit getShapeUnit();

    @Override
    public DimensionUnit getDimensionUnit();

    @Override
    public BBox2D scale(double scaleFactor);

    @Override
    public BBox2D translate(double... args);

    @Override
    public List<Point2D> getBounds();

    @Override
    public boolean isBounded();

    @Override
    public BBox2D copy();

    /**
     * @param point2D
     * @return
     */
    public BBox2D setSouthWest(Point2D point2D);

    /**
     * @param point2D
     * @return
     */
    public BBox2D setNorthEast(Point2D point2D);

    @Override
    public Point2D getNorthWest();

    @Override
    public Point2D getSouthEast();

    @Override
    public Point2D getNorthEast();

    @Override
    public Point2D getSouthWest();

    @Override
    public double getArea();

    @Override
    public double getHeight();

    @Override
    public double getWidth();

    @Override
    public Point2D getCentroid();
}
