/*
 * Decompiled with CFR 0.152.
 */
package terraml.commons.tuple;

import java.io.Serializable;
import java.util.Objects;

public final class Triplet<K, L, M>
implements Serializable {
    public final K k;
    public final L l;
    public final M m;

    public Triplet(K k, L l, M m) {
        this.k = k;
        this.l = l;
        this.m = m;
    }

    public static <K, L, M> Triplet<K, L, M> of(K k, L l, M m) {
        return new Triplet<K, L, M>(k, l, m);
    }

    public K getK() {
        return this.k;
    }

    public L getL() {
        return this.l;
    }

    public M getM() {
        return this.m;
    }

    protected Triplet<K, L, M> clone() {
        return new Triplet<K, L, M>(this.getK(), this.getL(), this.getM());
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + Objects.hashCode(this.k);
        hash = 53 * hash + Objects.hashCode(this.l);
        hash = 53 * hash + Objects.hashCode(this.m);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Triplet other = (Triplet)obj;
        if (!Objects.equals(this.k, other.k)) {
            return false;
        }
        if (!Objects.equals(this.l, other.l)) {
            return false;
        }
        return Objects.equals(this.m, other.m);
    }
}

