/*
 * Decompiled with CFR 0.152.
 */
package terraml.commons.tuple;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public final class NativeEntry<K, V>
implements Map.Entry<K, V>,
Serializable {
    private final K key;
    private V value;

    public NativeEntry(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public static <K, V> NativeEntry<K, V> of(K key, V value) {
        return new NativeEntry<K, V>(key, value);
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public V setValue(V value) {
        V reference = this.value;
        this.value = value;
        return reference;
    }

    public NativeEntry<K, V> clone() {
        return new NativeEntry<K, V>(this.getKey(), this.getValue());
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Objects.hashCode(this.key);
        hash = 47 * hash + Objects.hashCode(this.value);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NativeEntry other = (NativeEntry)obj;
        if (!Objects.equals(this.key, other.key)) {
            return false;
        }
        return Objects.equals(this.value, other.value);
    }
}

