/*
 * Decompiled with CFR 0.152.
 */
package terraml.commons.math;

import terraml.commons.Doubles;
import terraml.commons.math.Angle;

public final class Vec3d
implements Cloneable {
    public final double x;
    public final double y;
    public final double z;

    public Vec3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3d(Vec3d vector) {
        this.x = vector.getX();
        this.y = vector.getY();
        this.z = vector.getZ();
    }

    public static final Vec3d of(double x, double y, double z) {
        return new Vec3d(x, y, z);
    }

    public static final Vec3d of(Vec3d vector) {
        return new Vec3d(vector);
    }

    private static Vec3d _add(Vec3d vector, double nx, double ny, double nz) {
        return new Vec3d(vector.getX() + nx, vector.getY() + ny, vector.getZ() + nz);
    }

    private static Vec3d _sub(Vec3d vector, double nx, double ny, double nz) {
        return new Vec3d(vector.getX() - nx, vector.getY() - ny, vector.getZ() - nz);
    }

    public Vec3d add(Vec3d vector) {
        return Vec3d._add(this, vector.getX(), vector.getY(), vector.getZ());
    }

    public Vec3d sub(Vec3d vector) {
        return Vec3d._sub(this, vector.getX(), vector.getY(), vector.getZ());
    }

    public Vec3d translate(double t) {
        return Vec3d._add(this, t, t, t);
    }

    public Vec3d scale(double t) {
        return new Vec3d(this.x * t, this.y * t, this.z * t);
    }

    public Vec3d absoluted() {
        return new Vec3d(Math.abs(this.x), Math.abs(this.y), Math.abs(this.z));
    }

    private static double _negate(double q) {
        return Doubles.isGreaterEqual(q, 0.0) ? -1.0 * q : q;
    }

    public Vec3d negated() {
        return new Vec3d(Vec3d._negate(this.x), Vec3d._negate(this.y), Vec3d._negate(this.z));
    }

    public Vec3d rounded() {
        return new Vec3d(Math.round(this.x), Math.round(this.y), Math.round(this.z));
    }

    public Angle getAlpha() {
        double angle = Math.atan2(this.y, this.x);
        return Angle.fromDegree(angle);
    }

    public Angle getDelta() {
        return Angle.fromDegree(Math.asin(this.z / this.getNorm()));
    }

    public double getDotProduct(Vec3d vector) {
        double dx = this.x * vector.getX();
        double dy = this.y * vector.getY();
        double dz = this.z * vector.getZ();
        return dx + dy + dz;
    }

    public Vec3d getCrossProduct(Vec3d vector) {
        double dx = this.y * vector.getZ() - this.z * vector.getY();
        double dy = this.z * vector.getX() - this.x * vector.getZ();
        double dz = this.x * vector.getY() - this.y * vector.getX();
        return new Vec3d(dx, dy, dz);
    }

    public double getManhattanNorm() {
        Vec3d vector = this.absoluted();
        return vector.getX() + vector.getY() + vector.getZ();
    }

    public double getNormSquared() {
        return this.getDotProduct(this);
    }

    public double getNorm() {
        return Math.sqrt(this.getNormSquared());
    }

    public Vec3d getNormalized() {
        double normal = this.getNorm();
        if (Doubles.isEqual(normal, 0.0)) {
            throw new IllegalStateException("1/0 unknown");
        }
        return this.scale(1.0 / normal);
    }

    public double distanceSquaredTo(Vec3d vector) {
        Vec3d d = vector.sub(this);
        return d.getNormSquared();
    }

    public double distanceTo(Vec3d vector) {
        return Math.sqrt(this.distanceSquaredTo(vector));
    }

    public Vec3d getOrthogonal() {
        double threshold = 0.6 * this.getNorm();
        if (threshold == 0.0) {
            throw new IllegalArgumentException();
        }
        if (Doubles.isSmallerEqual(Math.abs(this.x), threshold)) {
            double inverse = 1.0 / Math.sqrt(this.y * this.y + this.z * this.z);
            return new Vec3d(0.0, inverse * this.z, -inverse * this.y);
        }
        if (Doubles.isSmallerEqual(Math.abs(this.y), threshold)) {
            double inverse = 1.0 / Math.sqrt(this.x * this.x + this.z * this.z);
            return new Vec3d(-inverse * this.z, 0.0, inverse * this.x);
        }
        double inverse = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y);
        return new Vec3d(inverse * this.y, -inverse * this.x, 0.0);
    }

    public Vec3d getZero() {
        return new Vec3d(0.0, 0.0, 0.0);
    }

    public double[] toArray() {
        return new double[]{this.x, this.y, this.z};
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + (int)(Double.doubleToLongBits(this.x) ^ Double.doubleToLongBits(this.x) >>> 32);
        hash = 59 * hash + (int)(Double.doubleToLongBits(this.y) ^ Double.doubleToLongBits(this.y) >>> 32);
        hash = 59 * hash + (int)(Double.doubleToLongBits(this.z) ^ Double.doubleToLongBits(this.z) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vec3d other = (Vec3d)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(other.y)) {
            return false;
        }
        return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(other.z);
    }
}

