/*
 * Decompiled with CFR 0.152.
 */
package terraml.commons.math;

import terraml.commons.Doubles;

public final class Vec2d
implements Cloneable {
    public final double x;
    public final double y;

    public Vec2d(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vec2d(Vec2d vector) {
        this.x = vector.x;
        this.y = vector.y;
    }

    public static final Vec2d of(double x, double y) {
        return new Vec2d(x, y);
    }

    public static final Vec2d of(Vec2d vector) {
        return new Vec2d(vector);
    }

    private static Vec2d _add(Vec2d vector, double nx, double ny) {
        return new Vec2d(vector.getX() + nx, vector.getY() + ny);
    }

    private static Vec2d _sub(Vec2d vector, double nx, double ny) {
        return new Vec2d(vector.getX() - nx, vector.getY() - ny);
    }

    public Vec2d add(Vec2d vector) {
        return Vec2d._add(this, vector.getX(), vector.getY());
    }

    public Vec2d sub(Vec2d vector) {
        return Vec2d._sub(this, vector.getX(), vector.getY());
    }

    public Vec2d translate(double t) {
        return Vec2d._add(this, t, t);
    }

    public Vec2d scale(double t) {
        return new Vec2d(this.x * t, this.y * t);
    }

    public Vec2d absoluted() {
        return new Vec2d(Math.abs(this.x), Math.abs(this.y));
    }

    private static double _negate(double q) {
        return Doubles.isGreaterEqual(q, 0.0) ? -1.0 * q : q;
    }

    public Vec2d negated() {
        return new Vec2d(Vec2d._negate(this.x), Vec2d._negate(this.y));
    }

    public Vec2d rounded() {
        return new Vec2d(Math.round(this.x), Math.round(this.y));
    }

    public double getDotProduct(Vec2d vector) {
        double dx = vector.getX() * this.x;
        double dy = vector.getY() * this.y;
        return dx + dy;
    }

    public double getCrossProduct(Vec2d vector0, Vec2d vector1) {
        Vec2d Qv = vector0.sub(this);
        Vec2d Wv = vector1.sub(this);
        return Qv.getX() * Wv.getY() - Qv.getY() * Wv.getX();
    }

    public double getManhattanNorm() {
        Vec2d vector = this.absoluted();
        return vector.getX() + vector.getY();
    }

    public double getNorm() {
        return Math.sqrt(this.getNormSquared());
    }

    public double getNormSquared() {
        return this.getDotProduct(this);
    }

    public Vec2d getNormalized() {
        double normal = this.getNorm();
        if (Doubles.isEqual(normal, 0.0)) {
            throw new IllegalStateException("1 / 0 is unknown");
        }
        return new Vec2d(this.scale(1.0 / normal));
    }

    public double distanceSquaredTo(Vec2d vector) {
        Vec2d d = vector.sub(this);
        return d.getNormSquared();
    }

    public double distanceTo(Vec2d vector) {
        return Math.sqrt(this.distanceSquaredTo(vector));
    }

    public Vec2d getZero() {
        return new Vec2d(0.0, 0.0);
    }

    public double[] toArray() {
        return new double[]{this.x, this.y};
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + (int)(Double.doubleToLongBits(this.x) ^ Double.doubleToLongBits(this.x) >>> 32);
        hash = 29 * hash + (int)(Double.doubleToLongBits(this.y) ^ Double.doubleToLongBits(this.y) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vec2d other = (Vec2d)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y);
    }
}

