/*
 * Decompiled with CFR 0.152.
 */
package terraml.commons.math;

import terraml.commons.Floats;

public final class RationalNumber
implements Comparable<RationalNumber> {
    public final float nominator;
    public final float denominator;

    public RationalNumber(float nominator, float denominator) {
        if (Floats.isEqual(denominator, 0.0f)) {
            throw new IllegalStateException("denominator is zero");
        }
        float gcd = RationalNumber.gcd(nominator, denominator);
        this.denominator = denominator / gcd;
        this.nominator = nominator / gcd;
    }

    public RationalNumber(RationalNumber rNumber) {
        this(rNumber.nominator, rNumber.denominator);
    }

    public static RationalNumber of(float pay, float payda) {
        return new RationalNumber(pay, payda);
    }

    public static float gcd(float m, float n) {
        float first = Math.abs(m);
        float second = Math.abs(n);
        if (second == 0.0f) {
            return first;
        }
        return RationalNumber.gcd(second, first % second);
    }

    public static float lcm(float m, float n) {
        float first = Math.abs(m);
        float second = Math.abs(n);
        return first * (second / RationalNumber.gcd(first, second));
    }

    public RationalNumber mul(RationalNumber rational) {
        float newNom = this.getNominator() * rational.getNominator();
        float newDenom = this.getDenominator() * rational.getDenominator();
        return new RationalNumber(newNom, newDenom);
    }

    public RationalNumber add(RationalNumber rational) {
        if (Floats.isEqual(rational.nominator, 0.0f)) {
            return this;
        }
        float gcd_nom = RationalNumber.gcd(this.getNominator(), rational.getNominator());
        float gcd_denom = RationalNumber.gcd(this.getDenominator(), rational.getDenominator());
        float formula = this.getNominator() / gcd_nom * (rational.getDenominator() * gcd_denom);
        float newNominator = new RationalNumber(formula += rational.getNominator() / gcd_nom * (this.getDenominator() / gcd_denom), RationalNumber.lcm(this.getDenominator(), rational.getDenominator())).getNominator();
        float newDenominator = newNominator * gcd_nom;
        return new RationalNumber(newNominator, newDenominator);
    }

    public RationalNumber sub(RationalNumber rational) {
        RationalNumber ref = new RationalNumber(-1.0f * rational.getNominator(), rational.getDenominator());
        return this.add(ref);
    }

    public RationalNumber div(RationalNumber rational) {
        RationalNumber inverse = RationalNumber.of(rational.getDenominator(), rational.getNominator());
        return this.mul(inverse);
    }

    public double toDouble() {
        return this.nominator / this.denominator;
    }

    public float toFloat() {
        return this.nominator / this.denominator;
    }

    public int toInt() {
        return Math.round(this.nominator / this.denominator);
    }

    public float getDenominator() {
        return this.denominator;
    }

    public float getNominator() {
        return this.nominator;
    }

    @Override
    public int compareTo(RationalNumber o) {
        return Float.compare(this.toFloat(), o.toFloat());
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + Float.floatToIntBits(this.nominator);
        hash = 23 * hash + Float.floatToIntBits(this.denominator);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RationalNumber other = (RationalNumber)obj;
        if (Float.floatToIntBits(this.nominator) != Float.floatToIntBits(other.nominator)) {
            return false;
        }
        return Float.floatToIntBits(this.denominator) == Float.floatToIntBits(other.denominator);
    }
}

