/*
 * Decompiled with CFR 0.152.
 */
package terraml.commons.math;

import terraml.commons.Doubles;

public final class Interval {
    public final double left;
    public final double right;

    public Interval(double left, double right) {
        this.left = Math.min(left, right);
        this.right = Math.max(left, right);
    }

    public Interval(Interval interval) {
        this.left = interval.left;
        this.right = interval.right;
    }

    public static Interval of(double left, double right) {
        return new Interval(left, right);
    }

    public static final boolean contains(double Ql, double Qr, double Wl, double Wr) {
        return Interval._contains(Ql, Qr, Wl, Wr);
    }

    public static final boolean inRange(double Ql, double Qr, double W) {
        return Interval._inRange(Ql, Qr, W);
    }

    public static final boolean intersects(double Ql, double Qr, double Wl, double Wr) {
        return Interval._intersects(Ql, Qr, Wl, Wr);
    }

    public static final Interval intersection(double Ql, double Qr, double Wl, double Wr) {
        return Interval._intersection(Ql, Qr, Wl, Wr);
    }

    private static boolean _contains(double Ql, double Qr, double Wl, double Wr) {
        return Doubles.isGreaterEqual(Wl, Ql) && Doubles.isSmallerEqual(Wr, Qr);
    }

    private static boolean _inRange(double Ql, double Qr, double W) {
        return Doubles.isGreaterEqual(W, Ql) && Doubles.isSmallerEqual(W, Qr);
    }

    private static boolean _intersects(double Ql, double Qr, double Wl, double Wr) {
        return Doubles.isSmallerEqual(Math.max(Ql, Wl), Math.min(Qr, Wr));
    }

    private static Interval _intersection(double Ql, double Qr, double Wl, double Wr) {
        double newLeft = Math.max(Ql, Wl);
        double newRight = Math.min(Qr, Wr);
        return new Interval(newLeft, newRight);
    }

    public boolean contains(Interval interval) {
        return Interval._contains(this.left, this.right, interval.getLeft(), interval.getRight());
    }

    public boolean contains(double ori, double dst) {
        return Interval._contains(this.left, this.right, Math.min(ori, dst), Math.max(ori, dst));
    }

    public boolean inRange(double related) {
        return Interval._inRange(this.left, this.right, related);
    }

    public boolean intersects(Interval interval) {
        return Interval._intersects(this.left, this.right, interval.getLeft(), interval.getRight());
    }

    public boolean intersects(double ori, double dst) {
        return Interval._intersects(this.left, this.right, Math.min(ori, dst), Math.max(ori, dst));
    }

    public Interval intersection(Interval interval) {
        return Interval._intersection(this.left, this.right, interval.getLeft(), interval.getRight());
    }

    public Interval intersection(double ori, double dst) {
        return Interval._intersection(this.left, this.right, Math.min(ori, dst), Math.max(ori, dst));
    }

    public double getLeft() {
        return this.left;
    }

    public double getRight() {
        return this.right;
    }

    public double getMiddle() {
        return (this.left + this.right) * 0.5;
    }

    public double getLength() {
        return this.right - this.left;
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + (int)(Double.doubleToLongBits(this.left) ^ Double.doubleToLongBits(this.left) >>> 32);
        hash = 59 * hash + (int)(Double.doubleToLongBits(this.right) ^ Double.doubleToLongBits(this.right) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Interval other = (Interval)obj;
        if (Double.doubleToLongBits(this.left) != Double.doubleToLongBits(other.left)) {
            return false;
        }
        return Double.doubleToLongBits(this.right) == Double.doubleToLongBits(other.right);
    }
}

