/*
 * Decompiled with CFR 0.152.
 */
package terraml.commons.math;

import terraml.commons.Doubles;

public final class Angle
implements Comparable<Angle> {
    public final double degree;
    public final double radian;

    private Angle(double degree) {
        this.degree = degree;
        this.radian = Math.toRadians(this.degree);
    }

    public Angle(Angle angle) {
        this.degree = angle.degree;
        this.radian = angle.radian;
    }

    public static Angle fromDegree(double degree) {
        return new Angle(degree);
    }

    public static Angle fromRadian(double radian) {
        return new Angle(Math.toDegrees(radian));
    }

    public Angle add(Angle angle) {
        return Angle.fromDegree(this.degree + angle.degree);
    }

    public Angle sub(Angle angle) {
        return Angle.fromDegree(this.degree - angle.degree);
    }

    public Angle mul(Angle angle) {
        return Angle.fromDegree(this.degree * angle.degree);
    }

    public Angle div(Angle angle) {
        return Angle.fromDegree(this.degree / angle.degree);
    }

    public Angle min(Angle angle) {
        if (Doubles.isSmallerEqual(this.compareTo(angle), 0.0)) {
            return this;
        }
        return new Angle(angle);
    }

    public Angle max(Angle angle) {
        if (Doubles.isGreaterEqual(this.compareTo(angle), 0.0)) {
            return this;
        }
        return new Angle(angle);
    }

    public double sin() {
        return Math.sin(this.radian);
    }

    public double asin() {
        return Math.asin(this.radian);
    }

    public double cos() {
        return Math.cos(this.radian);
    }

    public double acos() {
        return Math.acos(this.radian);
    }

    public double atan() {
        return Math.atan(this.radian);
    }

    public double getRadian() {
        return this.radian;
    }

    public double getDegree() {
        return this.degree;
    }

    @Override
    public int compareTo(Angle angle) {
        if (Doubles.isSmaller(this.radian, angle.degree)) {
            return -1;
        }
        if (Doubles.isEqual(this.radian, angle.degree)) {
            return 0;
        }
        return 1;
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (int)(Double.doubleToLongBits(this.degree) ^ Double.doubleToLongBits(this.degree) >>> 32);
        hash = 37 * hash + (int)(Double.doubleToLongBits(this.radian) ^ Double.doubleToLongBits(this.radian) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Angle other = (Angle)obj;
        if (Double.doubleToLongBits(this.degree) != Double.doubleToLongBits(other.degree)) {
            return false;
        }
        return Double.doubleToLongBits(this.radian) == Double.doubleToLongBits(other.radian);
    }
}

