/*
 * Decompiled with CFR 0.152.
 */
package terraml.commons.j2js;

import java.io.Serializable;
import terraml.commons.j2js.Validation;
import terraml.commons.j2js.VariableBuilder;

public class Variable
implements Serializable {
    private final String name;
    private final Object value;
    private final Type type;

    public Variable(String name, Object value, Type type) {
        this.name = name;
        this.value = value;
        this.type = type;
    }

    public Variable(String name, Object value) {
        this(name, value, Type.VAR);
    }

    public Variable(VariableBuilder builder) {
        this.name = builder.getName();
        this.value = builder.getValue();
        this.type = builder.getType();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.type.toString());
        builder.append(" ");
        builder.append(this.name);
        builder.append(" = ");
        builder.append(this.value);
        String string = builder.toString();
        if (!string.endsWith(";")) {
            string = string + ";";
        }
        return string;
    }

    public boolean isNameValid() {
        if (this.getName() == null || this.getName().isEmpty()) {
            return false;
        }
        if (Character.isDigit(this.getName().charAt(0))) {
            return false;
        }
        if (Validation.KEYWORDS.contains(this.getName())) {
            return false;
        }
        for (String special : Validation.SPECIALS) {
            if (!this.getName().contains(special)) continue;
            return false;
        }
        return true;
    }

    public static Variable of(String name, Object value, Type type) {
        return new Variable(name, value, type);
    }

    public static Variable of(String name, Object value) {
        return new Variable(name, value);
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        VAR,
        CONST,
        LET;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

