/*
 * Decompiled with CFR 0.152.
 */
package terraml.commons.j2js;

import java.io.Serializable;
import java.util.Collection;
import terraml.commons.j2js.FunctionBuilder;
import terraml.commons.j2js.Parameter;
import terraml.commons.j2js.Validation;

public class Function
implements Serializable {
    private final String objectName;
    private final String name;
    private final Collection<Parameter> parameters;

    public Function(String objectName, String name, Collection<Parameter> parameters) {
        this.objectName = objectName;
        this.name = name;
        this.parameters = parameters;
    }

    public Function(FunctionBuilder builder) {
        this.objectName = builder.getObjectName();
        this.name = builder.getName();
        this.parameters = builder.getParameters();
    }

    public static Function of(String objectName, String name, Collection<Parameter> parameters) {
        return new Function(objectName, name, parameters);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.objectName);
        builder.append(".");
        builder.append(this.name);
        builder.append("(");
        if (this.parameters == null) {
            builder.append(");");
            return builder.toString();
        }
        for (Parameter each : this.parameters) {
            builder.append(each);
            builder.append(",");
        }
        String string = builder.toString();
        if (string.endsWith(",")) {
            string = string.substring(0, string.length() - 1);
        }
        return string + ");";
    }

    private static final boolean isNameValid(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        if (Character.isDigit(string.charAt(0))) {
            return false;
        }
        if (Validation.KEYWORDS.contains(string)) {
            return false;
        }
        for (String special : Validation.SPECIALS) {
            if (!string.contains(special)) continue;
            return false;
        }
        return true;
    }

    public boolean isObjectNameValid() {
        return Function.isNameValid(this.getObjectName());
    }

    public boolean isNameValid() {
        return Function.isNameValid(this.getName());
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getName() {
        return this.name;
    }

    public Collection<Parameter> getParameters() {
        return this.parameters;
    }
}

