/*
 * Decompiled with CFR 0.152.
 */
package terraml.commons;

import terraml.commons.Objects;
import terraml.commons.tuple.LatlonEntry;

public final class Strings {
    private Strings() {
    }

    public static String inQuote(String string) {
        return "'" + string + "'";
    }

    public static String inBrackets(String string) {
        return "[" + string + "]";
    }

    public static String inCurlyBraces(String string) {
        return "{" + string + "}";
    }

    public static boolean isBlank(String string) {
        return string.equals("");
    }

    public static boolean nullOrBlank(String string) {
        return Objects.isNull(string) || Strings.isBlank(string);
    }

    public static String toString(int integer) {
        return String.valueOf(integer);
    }

    public static String toString(double dbl) {
        return String.valueOf(dbl);
    }

    public static String toString(boolean bool) {
        return bool ? "true" : "false";
    }

    public static String toString(LatlonEntry latlonEntry) {
        return latlonEntry.lat() + ", " + latlonEntry.lon();
    }

    public static double toDouble(String string) {
        return Double.valueOf(string);
    }

    public static double toInt(String string) {
        return Integer.valueOf(string).intValue();
    }

    public static boolean toBool(String string) {
        return Boolean.valueOf(string);
    }

    public static String clear(String string) {
        return string.substring(1, string.length() - 1);
    }

    public static String orElse(Object object, String orElse) {
        return object instanceof String ? (String)object : orElse;
    }

    public static String join(String ... arg) {
        if (arg == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String each : arg) {
            builder.append(each != null ? each : "");
        }
        return builder.toString();
    }

    public static String join(Character seperator, String ... arg) {
        if (arg == null) {
            return "";
        }
        Character tmp = Character.valueOf(seperator != null ? seperator.charValue() : (char)'\u0000');
        StringBuilder builder = new StringBuilder();
        for (String each : arg) {
            builder.append(each != null ? each : "");
            builder.append(tmp);
        }
        return builder.toString();
    }
}

