/*
 * Decompiled with CFR 0.152.
 */
package terraml.commons;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;

public final class Objects {
    private Objects() {
    }

    public static <Q> Q deepCopy(Q object) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(object);
        oos.flush();
        oos.close();
        bos.close();
        byte[] byteData = bos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(byteData);
        return (Q)new ObjectInputStream(bais).readObject();
    }

    public static boolean instanceOf(Object object, Class<?> klas) {
        if (object == null || klas == null) {
            return false;
        }
        return klas.isInstance(object);
    }

    public static boolean nonNull(Object object) {
        return object != null;
    }

    public static boolean isNull(Object object) {
        return object == null;
    }

    public static boolean isArray(Object object) {
        return object != null && object.getClass().isArray();
    }

    public static boolean equals(Object object0, Object object1) {
        return object0 != null && object1 != null && object0.equals(object1);
    }

    public static <Q> boolean contains(Q[] array, Q object) {
        if (!Objects.isNull(array) && !Objects.isNull(object)) {
            for (Q each : array) {
                if (!each.equals(object)) continue;
                return true;
            }
        }
        return false;
    }

    public static <Q> int indexOf(Q[] array, Q object) {
        if (!Objects.isNull(array) && !Objects.isNull(object)) {
            int length = array.length;
            for (int t = 0; t < length; ++t) {
                if (!array[t].equals(object)) continue;
                return t;
            }
        }
        return -1;
    }

    public static Object[] add(Object[] array, Object element) {
        int length = array.length;
        Object[] newArray = new Object[length + 1];
        System.arraycopy(array, 0, newArray, 0, length);
        newArray[length] = element;
        return newArray;
    }

    public static boolean isEmpty(Object[] array) {
        return Objects.isNull(array) || array.length == 0;
    }

    public static Object[] remove(Object[] array, int index) {
        int length = array.length;
        if (index > length || index < 0) {
            throw new IllegalArgumentException("index is invalid");
        }
        Object[] newArray = new Object[length - 1];
        System.arraycopy(array, 0, newArray, 0, index);
        if (index > length - 1) {
            return newArray;
        }
        int destination = length - index - 1;
        System.arraycopy(array, index + 1, newArray, index, destination);
        return newArray;
    }

    public static Object[] remove(Object[] array, Object element) {
        int idx = Objects.indexOf(array, element);
        if (idx == -1) {
            throw new IllegalArgumentException("there is no such element in the given array.");
        }
        return Objects.remove(array, idx);
    }

    public static <Q> Q[] toArray(Class reference, int length) {
        return (Object[])Array.newInstance(reference.getComponentType(), length);
    }

    public static long toLong(Object object) {
        if (object == null) {
            return 0L;
        }
        Class<?> classType = object.getClass();
        if (classType.getSuperclass().equals(Number.class)) {
            Number theNumber = (Number)object;
            return theNumber.longValue();
        }
        if (object instanceof String) {
            return Long.valueOf((String)object);
        }
        throw new IllegalArgumentException("Invalid arg");
    }

    public static float toFloat(Object object) {
        if (object == null) {
            return 0.0f;
        }
        Class<?> classType = object.getClass();
        if (classType.getSuperclass().equals(Number.class)) {
            Number theNumber = (Number)object;
            return theNumber.floatValue();
        }
        if (object instanceof String) {
            return Float.valueOf((String)object).floatValue();
        }
        throw new IllegalArgumentException("Invalid arg");
    }

    public static double toDouble(Object object) {
        if (object == null) {
            return 0.0;
        }
        Class<?> classType = object.getClass();
        if (classType.getSuperclass().equals(Number.class)) {
            Number theNumber = (Number)object;
            return theNumber.doubleValue();
        }
        if (object instanceof String) {
            return Double.valueOf((String)object);
        }
        throw new IllegalArgumentException("Invalid arg");
    }

    public static int toInt(Object object) {
        if (object == null) {
            return 0;
        }
        Class<?> classType = object.getClass();
        if (classType.getSuperclass().equals(Number.class)) {
            Number theNumber = (Number)object;
            return theNumber.intValue();
        }
        if (object instanceof String) {
            return Integer.valueOf((String)object);
        }
        throw new IllegalArgumentException("Invalid arg");
    }

    public static boolean isNumber(Object object) {
        return object.getClass().getSuperclass().equals(Number.class);
    }

    public static boolean toBool(Object object) {
        boolean bool;
        if (object instanceof Boolean) {
            bool = (Boolean)object;
        } else if (object instanceof String) {
            bool = Boolean.valueOf((String)object);
        } else {
            throw new IllegalArgumentException("Invalid arg");
        }
        return bool;
    }
}

