/*
 * Decompiled with CFR 0.152.
 */
package terraml.commons;

import java.util.Arrays;
import java.util.stream.LongStream;
import terraml.commons.Objects;

public final class Longs {
    private Longs() {
    }

    public static int indexOf(long[] array, long element) {
        int length = array.length;
        for (int t = 0; t < length; ++t) {
            if (Long.compare(array[t], element) != 0) continue;
            return t;
        }
        return -1;
    }

    public static boolean contains(long[] array, long element) {
        int length = array.length;
        for (int t = 0; t < length; ++t) {
            if (Long.compare(array[t], element) != 0) continue;
            return true;
        }
        return false;
    }

    public static int findGreatestIndex(long[] array) {
        int found = -1;
        if (Objects.isNull(array)) {
            return found;
        }
        int length = array.length;
        found = 0;
        boolean isFound = false;
        for (int t = 0; t < length; ++t) {
            if (Long.compare(array[t], array[found]) <= 0) continue;
            found = t;
            isFound = true;
        }
        return isFound ? found : -1;
    }

    public static int findSmallestIndex(long[] array) {
        int found = -1;
        if (Objects.isNull(array)) {
            return found;
        }
        int length = array.length;
        found = 0;
        boolean isFound = false;
        for (int t = 0; t < length; ++t) {
            if (Long.compare(array[t], array[found]) >= 0) continue;
            found = t;
            isFound = true;
        }
        return isFound ? found : -1;
    }

    public static long[] add(long[] array, long element) {
        int length = array.length;
        long[] newArray = new long[length + 1];
        System.arraycopy(array, 0, newArray, 0, length);
        newArray[length] = element;
        return newArray;
    }

    public static boolean isEmpty(long[] array) {
        return Objects.isNull(array) || array.length == 0;
    }

    public static long[] remove(long[] array, int index) {
        int length = array.length;
        if (index > length || index < 0) {
            throw new IllegalArgumentException("index is invalid");
        }
        long[] newArray = new long[length - 1];
        System.arraycopy(array, 0, newArray, 0, index);
        if (index > length - 1) {
            return newArray;
        }
        int destination = length - index - 1;
        System.arraycopy(array, index + 1, newArray, index, destination);
        return newArray;
    }

    public static long[] remove(long[] array, long element) {
        int idx = Longs.indexOf(array, element);
        if (idx == -1) {
            throw new IllegalArgumentException("there is no such element in the given array.");
        }
        return Longs.remove(array, idx);
    }

    public static long findGreatest(long[] array) {
        long found = -1L;
        if (Objects.isNull(array)) {
            return found;
        }
        int length = array.length;
        found = array[0];
        for (int t = 0; t < length; ++t) {
            found = Math.max(array[t], found);
        }
        return found;
    }

    public static long findSmallest(long[] array) {
        long found = -1L;
        if (Objects.isNull(array)) {
            return found;
        }
        int length = array.length;
        found = array[0];
        for (int t = 0; t < length; ++t) {
            found = Math.min(array[t], found);
        }
        return found;
    }

    public static long[] sort(long[] source) {
        return LongStream.of(source).sorted().toArray();
    }

    public static long[] removeAll(long[] source, long[] rmv) {
        return Arrays.stream(rmv).filter(each -> !Longs.contains(source, each)).toArray();
    }

    public static boolean isEqual(long number0, long number1) {
        return Long.compare(number0, number1) == 0;
    }

    public static boolean isGreater(long number0, long number1) {
        return Long.compare(number0, number1) > 0;
    }

    public static boolean isGreaterEqual(long number0, long number1) {
        return Long.compare(number0, number1) >= 0;
    }

    public static boolean isSmaller(long number0, long number1) {
        return Long.compare(number0, number1) < 0;
    }

    public static boolean isSmallerEqual(long number0, long number1) {
        return Long.compare(number0, number1) <= 0;
    }

    public static boolean isNegative(long number0) {
        return Long.compare(number0, 0L) < 0;
    }

    public static boolean isPositive(long number0) {
        return Long.compare(number0, 0L) > 0;
    }
}

