/*
 * Decompiled with CFR 0.152.
 */
package terraml.commons;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import terraml.commons.Objects;

public final class Lists {
    public static final List EMPTY_LIST = Collections.emptyList();

    private Lists() {
    }

    public static <Q> List<Q> toList(Iterable<Q> elements) {
        if (elements == null) {
            return new ArrayList();
        }
        ArrayList arraylist = new ArrayList();
        elements.forEach(item -> arraylist.add(item));
        return arraylist;
    }

    public static <Q> List<Q> toList(Iterator<Q> elements) {
        if (elements == null) {
            return new ArrayList();
        }
        ArrayList<Q> arraylist = new ArrayList<Q>();
        Iterator<Q> iterator = elements;
        while (iterator.hasNext()) {
            arraylist.add(iterator.next());
        }
        return arraylist;
    }

    public static <Q> Q min(List<Q> list, Comparator<Q> comparator) {
        return (Q)list.stream().min(comparator).get();
    }

    public static <Q> Q max(List<Q> list, Comparator<Q> comparator) {
        return (Q)list.stream().max(comparator).get();
    }

    public static <Q> List<Q> select(List<Q> list, Predicate<Q> predicate) {
        return list.stream().filter(predicate).collect(Collectors.toList());
    }

    public static <Q> List<Q> reject(List<Q> list, Predicate<Q> predicate) {
        return list.stream().filter(predicate.negate()).collect(Collectors.toList());
    }

    public static <Q> List<Q> deepCopy(List<Q> list) throws IOException, ClassNotFoundException {
        ArrayList<Q> dCopy = new ArrayList<Q>(list.size());
        for (Q each : list) {
            dCopy.add(Objects.deepCopy(each));
        }
        return dCopy;
    }

    public static <Q> List<Q> deepCopy(List<Q> list, List<Q> empty) throws IOException, ClassNotFoundException {
        for (Q each : list) {
            empty.add(Objects.deepCopy(each));
        }
        return empty;
    }

    public static <Q> List<Q> intersection(List<Q> source, List<Q> target) {
        ArrayList<Q> rs = new ArrayList<Q>();
        for (Q each : target) {
            if (!source.contains(each)) continue;
            rs.add(each);
        }
        return rs;
    }

    public static boolean nullOrEmpty(List collection) {
        return collection == null || collection.isEmpty();
    }
}

