/*
 * Decompiled with CFR 0.152.
 */
package terraml.commons;

import java.util.Arrays;
import java.util.stream.IntStream;
import terraml.commons.Objects;

public final class Ints {
    private Ints() {
    }

    public static int indexOf(int[] array, int element) {
        int length = array.length;
        for (int t = 0; t < length; ++t) {
            if (array[t] != element) continue;
            return t;
        }
        return -1;
    }

    public static boolean contains(int[] array, int element) {
        int length = array.length;
        for (int t = 0; t < length; ++t) {
            if (array[t] != element) continue;
            return true;
        }
        return false;
    }

    public static int[] emptyArray() {
        return new int[0];
    }

    public static int findGreatestIndex(int[] array) {
        int found = -1;
        if (Objects.isNull(array)) {
            return found;
        }
        int length = array.length;
        found = 0;
        boolean isFound = false;
        for (int t = 0; t < length; ++t) {
            if (array[t] <= array[found]) continue;
            found = t;
            isFound = true;
        }
        return isFound ? found : -1;
    }

    public static int findSmallestIndex(int[] array) {
        int found = -1;
        if (Objects.isNull(array)) {
            return found;
        }
        int length = array.length;
        found = 0;
        boolean isFound = false;
        for (int t = 0; t < length; ++t) {
            if (array[t] >= array[found]) continue;
            found = t;
            isFound = true;
        }
        return isFound ? found : -1;
    }

    public static int[] add(int[] array, int element) {
        int length = array.length;
        int[] newArray = new int[length + 1];
        System.arraycopy(array, 0, newArray, 0, length);
        newArray[length] = element;
        return newArray;
    }

    public static boolean isEmpty(int[] array) {
        return Objects.isNull(array) || array.length == 0;
    }

    public static int[] removeFromIndex(int[] array, int index) {
        int length = array.length;
        if (index > length || index < 0) {
            throw new IllegalArgumentException("index is invalid");
        }
        int[] newArray = new int[length - 1];
        System.arraycopy(array, 0, newArray, 0, index);
        if (index > length - 1) {
            return newArray;
        }
        int destination = length - index - 1;
        System.arraycopy(array, index + 1, newArray, index, destination);
        return newArray;
    }

    public static int[] remove(int[] array, int element) {
        int idx = Ints.indexOf(array, element);
        if (idx == -1) {
            throw new IllegalArgumentException("there is no such element in the given array.");
        }
        return Ints.removeFromIndex(array, idx);
    }

    public static int findGreatest(int[] array) {
        int found = -1;
        if (Objects.isNull(array)) {
            return found;
        }
        int length = array.length;
        found = array[0];
        for (int t = 0; t < length; ++t) {
            found = Math.max(array[t], found);
        }
        return found;
    }

    public static int findSmallest(int[] array) {
        int found = -1;
        if (Objects.isNull(array)) {
            return found;
        }
        int length = array.length;
        found = array[0];
        for (int t = 0; t < length; ++t) {
            found = Math.min(array[t], found);
        }
        return found;
    }

    public static int[] sort(int[] source) {
        return IntStream.of(source).sorted().toArray();
    }

    public static int[] removeAll(int[] source, int[] rmv) {
        return Arrays.stream(rmv).filter(each -> !Ints.contains(source, each)).toArray();
    }

    public static boolean isEqual(int number0, int number1) {
        return Integer.compare(number0, number1) == 0;
    }

    public static boolean isGreater(int number0, int number1) {
        return number0 > number1;
    }

    public static boolean isGreaterEqual(int number0, int number1) {
        return number0 >= number1;
    }

    public static boolean isSmaller(int number0, int number1) {
        return number0 < number1;
    }

    public static boolean isSmallerEqual(int number0, int number1) {
        return number0 <= number1;
    }

    public static boolean isNegative(int number0) {
        return number0 < 0;
    }

    public static boolean isPositive(int number0) {
        return number0 > 0;
    }
}

