/*
 * Decompiled with CFR 0.152.
 */
package terraml.commons;

import terraml.commons.Objects;

public final class Floats {
    private Floats() {
    }

    public static int indexOf(float[] array, float element) {
        int length = array.length;
        for (int t = 0; t < length; ++t) {
            if (Float.compare(array[t], element) != 0) continue;
            return t;
        }
        return -1;
    }

    public static boolean contains(float[] array, float element) {
        int length = array.length;
        for (int t = 0; t < length; ++t) {
            if (Float.compare(array[t], element) != 0) continue;
            return true;
        }
        return false;
    }

    public static int findGreatestIndex(float[] array) {
        int found = -1;
        if (Objects.isNull(array)) {
            return found;
        }
        int length = array.length;
        found = 0;
        boolean isFound = false;
        for (int t = 0; t < length; ++t) {
            if (Float.compare(array[t], array[found]) <= 0) continue;
            found = t;
            isFound = true;
        }
        return isFound ? found : -1;
    }

    public static int findSmallestIndex(float[] array) {
        int found = -1;
        if (Objects.isNull(array)) {
            return found;
        }
        int length = array.length;
        found = 0;
        boolean isFound = false;
        for (int t = 0; t < length; ++t) {
            if (Float.compare(array[t], array[found]) >= 0) continue;
            found = t;
            isFound = true;
        }
        return isFound ? found : -1;
    }

    public static float[] add(float[] array, float element) {
        int length = array.length;
        float[] newArray = new float[length + 1];
        System.arraycopy(array, 0, newArray, 0, length);
        newArray[length] = element;
        return newArray;
    }

    public static boolean isEmpty(float[] array) {
        return Objects.isNull(array) || array.length == 0;
    }

    public static float[] remove(float[] array, int index) {
        int length = array.length;
        if (index > length || index < 0) {
            throw new IllegalArgumentException("index is invalid");
        }
        float[] newArray = new float[length - 1];
        System.arraycopy(array, 0, newArray, 0, index);
        if (index > length - 1) {
            return newArray;
        }
        int destination = length - index - 1;
        System.arraycopy(array, index + 1, newArray, index, destination);
        return newArray;
    }

    public static float[] remove(float[] array, float element) {
        int idx = Floats.indexOf(array, element);
        if (idx == -1) {
            throw new IllegalArgumentException("there is no such element in the given array.");
        }
        return Floats.remove(array, idx);
    }

    public static float findGreatest(float[] array) {
        float found = -1.0f;
        if (Objects.isNull(array)) {
            return found;
        }
        int length = array.length;
        found = array[0];
        for (int t = 0; t < length; ++t) {
            found = Math.max(array[t], found);
        }
        return found;
    }

    public static float findSmallest(float[] array) {
        float found = -1.0f;
        if (Objects.isNull(array)) {
            return found;
        }
        int length = array.length;
        found = array[0];
        for (int t = 0; t < length; ++t) {
            found = Math.min(array[t], found);
        }
        return found;
    }

    public static boolean isEqual(float number0, float number1) {
        return Float.compare(number0, number1) == 0;
    }

    public static boolean isGreater(float number0, float number1) {
        return Float.compare(number0, number1) > 0;
    }

    public static boolean isGreaterEqual(float number0, float number1) {
        return Float.compare(number0, number1) >= 0;
    }

    public static boolean isSmaller(float number0, float number1) {
        return Float.compare(number0, number1) < 0;
    }

    public static boolean isSmallerEqual(float number0, float number1) {
        return Float.compare(number0, number1) <= 0;
    }

    public static boolean isNegative(float number0) {
        return Float.compare(number0, 0.0f) < 0;
    }

    public static boolean isPositive(float number0) {
        return Float.compare(number0, 0.0f) > 0;
    }
}

