/*
 * Decompiled with CFR 0.152.
 */
package terraml.commons;

import java.util.Arrays;
import java.util.stream.DoubleStream;
import terraml.commons.Objects;

public final class Doubles {
    private Doubles() {
    }

    public static int indexOf(double[] array, double element) {
        int length = array.length;
        for (int t = 0; t < length; ++t) {
            if (Double.compare(array[t], element) != 0) continue;
            return t;
        }
        return -1;
    }

    public static boolean contains(double[] array, double element) {
        int length = array.length;
        for (int t = 0; t < length; ++t) {
            if (Double.compare(array[t], element) != 0) continue;
            return true;
        }
        return false;
    }

    public static int findGreatestIndex(double[] array) {
        int found = -1;
        if (Objects.isNull(array)) {
            return found;
        }
        int length = array.length;
        found = 0;
        boolean isFound = false;
        for (int t = 0; t < length; ++t) {
            if (Double.compare(array[t], array[found]) <= 0) continue;
            found = t;
            isFound = true;
        }
        return isFound ? found : -1;
    }

    public static int findSmallestIndex(double[] array) {
        int found = -1;
        if (Objects.isNull(array)) {
            return found;
        }
        int length = array.length;
        found = 0;
        boolean isFound = false;
        for (int t = 0; t < length; ++t) {
            if (Double.compare(array[t], array[found]) >= 0) continue;
            found = t;
            isFound = true;
        }
        return isFound ? found : -1;
    }

    public static double[] add(double[] array, double element) {
        int length = array.length;
        double[] newArray = new double[length + 1];
        System.arraycopy(array, 0, newArray, 0, length);
        newArray[length] = element;
        return newArray;
    }

    public static boolean isEmpty(double[] array) {
        return Objects.isNull(array) || array.length == 0;
    }

    public static double[] remove(double[] array, int index) {
        int length = array.length;
        if (index > length || index < 0) {
            throw new IllegalArgumentException("index is invalid");
        }
        double[] newArray = new double[length - 1];
        System.arraycopy(array, 0, newArray, 0, index);
        if (index > length - 1) {
            return newArray;
        }
        int destination = length - index - 1;
        System.arraycopy(array, index + 1, newArray, index, destination);
        return newArray;
    }

    public static double[] remove(double[] array, double element) {
        int idx = Doubles.indexOf(array, element);
        if (idx == -1) {
            throw new IllegalArgumentException("there is no such element in the given array.");
        }
        return Doubles.remove(array, idx);
    }

    public static double findGreatest(double[] array) {
        double found = -1.0;
        if (Objects.isNull(array)) {
            return found;
        }
        int length = array.length;
        found = array[0];
        for (int t = 0; t < length; ++t) {
            found = Math.max(array[t], found);
        }
        return found;
    }

    public static double findSmallest(double[] array) {
        double found = -1.0;
        if (Objects.isNull(array)) {
            return found;
        }
        int length = array.length;
        found = array[0];
        for (int t = 0; t < length; ++t) {
            found = Math.min(array[t], found);
        }
        return found;
    }

    public static double[] sort(double[] source) {
        return DoubleStream.of(source).sorted().toArray();
    }

    public static double[] removeAll(double[] source, double[] rmv) {
        return Arrays.stream(rmv).filter(each -> !Doubles.contains(source, each)).toArray();
    }

    public static final boolean isEqual(double number0, double number1) {
        return Double.compare(number0, number1) == 0;
    }

    public static final boolean isGreater(double number0, double number1) {
        return Double.compare(number0, number1) > 0;
    }

    public static final boolean isGreaterEqual(double number0, double number1) {
        return Double.compare(number0, number1) >= 0;
    }

    public static final boolean isSmaller(double number0, double number1) {
        return Double.compare(number0, number1) < 0;
    }

    public static final boolean isSmallerEqual(double number0, double number1) {
        return Double.compare(number0, number1) <= 0;
    }

    public static final boolean isNegative(double number0) {
        return Double.compare(number0, 0.0) < 0;
    }

    public static final boolean isPositive(double number0) {
        return Double.compare(number0, 0.0) > 0;
    }

    public static final boolean isNumericallyEqual(double number0, double number1) {
        return Double.compare(Math.abs(number0 - number1), 1.0E-8) < 0;
    }

    public static final boolean isNumericallyEqual(double number0, double number1, double epsilon) {
        return Double.compare(Math.abs(number0 - number1), epsilon) < 0;
    }
}

