/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This file is part of terraml-commons project.
 *
 * This file incorporates work covered by
 * the following copyright and permission notices:
 *
 * Copyright (C) 2018 Terra Software Informatics LLC. | info@terrayazilim.com.tr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package terraml.commons.j2js;

/**
 * @author M.Çağrı Tepebaşılı - cagritepebasili [at] protonmail [dot] com
 * @version 1.0.2-SNAPSHOT
 */
public final class VariableBuilder {

    private String name;
    private Object value;
    private Variable.Type type;

    private VariableBuilder() {
    }
    
    /**
     * @return 
     */
    public static VariableBuilder create() {
        return new VariableBuilder();
    }
    
    public Variable build() {
        return new Variable(this);
    }

    /**
     * @param name
     * @return 
     */
    public VariableBuilder setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * @param value
     * @return 
     */
    public VariableBuilder setValue(Object value) {
        this.value = value;
        return this;
    }

    /**
     * @param type
     * @return 
     */
    public VariableBuilder setType(Variable.Type type) {
        this.type = type;
        return this;
    }

    /**
     * @return 
     */
    public String getName() {
        return name;
    }

    /**
     * @return 
     */
    public Object getValue() {
        return value;
    }

    /**
     * @return 
     */
    public Variable.Type getType() {
        return type;
    }
}
