/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This file is part of terraml-commons project.
 *
 * This file incorporates work covered by
 * the following copyright and permission notices:
 *
 * Copyright (C) 2018 Terra Software Informatics LLC. | info@terrayazilim.com.tr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package terraml.commons.j2js;

import java.io.Serializable;

/**
 * @author M.Çağrı Tepebaşılı - cagritepebasili [at] protonmail [dot] com
 * @version 1.0.2-SNAPSHOT
 */
public class Variable implements Serializable {

    static public enum Type {
        VAR,
        CONST,
        LET;

        @Override
        public String toString() {
            return super.toString().toLowerCase();
        }
    }

    private final String name;
    private final Object value;
    private final Type type;

    /**
     * @param name
     * @param value
     * @param type
     */
    public Variable(String name, Object value, Type type) {
        this.name = name;
        this.value = value;
        this.type = type;
    }

    /**
     * @param name
     * @param value
     */
    public Variable(String name, Object value) {
        this(name, value, Type.VAR);
    }

    /**
     * @param builder
     */
    public Variable(VariableBuilder builder) {
        this.name = builder.getName();
        this.value = builder.getValue();
        this.type = builder.getType();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();

        builder.append(type.toString());
        builder.append(" ");
        builder.append(name);
        builder.append(" = ");
        builder.append(value);

        String string = builder.toString();

        if (!string.endsWith(";")) {
            string = string + ";";
        }

        return string;
    }
    
    /**
     * @return 
     */
    public boolean isNameValid() {
        if (getName() == null || getName().isEmpty()) {
            return false;
        }
        
        if (Character.isDigit(getName().charAt(0))) {
            return false;
        }
        
        if (Validation.KEYWORDS.contains(getName())) {
            return false;
        }
        
        
        for (String special : Validation.SPECIALS) {
            if (getName().contains(special)) {
                return false;
            }
        }

        return true;
    }

    /**
     * @param name
     * @param value
     * @param type
     * @return
     */
    public static Variable of(String name, Object value, Type type) {
        return new Variable(name, value, type);
    }

    /**
     * @param name
     * @param value
     * @return
     */
    public static Variable of(String name, Object value) {
        return new Variable(name, value);
    }

    public String getName() {
        return name;
    }

    public Object getValue() {
        return value;
    }

    public Type getType() {
        return type;
    }
}
