/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This file is part of terraml-commons project.
 *
 * This file incorporates work covered by
 * the following copyright and permission notices:
 *
 * Copyright (C) 2018 Terra Software Informatics LLC. | info@terrayazilim.com.tr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package terraml.commons.j2js;

import java.util.HashSet;

/**
 * @author M.Çağrı Tepebaşılı - cagritepebasili [at] protonmail [dot] com
 * @version 1.0.2-SNAPSHOT
 */
public final class Validation {

    public final static HashSet<String> KEYWORDS = new HashSet<String>(){{
        add("return");add("for");add("const");
        add("true");add("char");add("Finally");
        add("catch");add("byte");add("enum");
        add("False");add("boolean");add("function");
        add("Implements");add("typeof");add("transient");
        add("break");add("Void");add("default");
        add("do");add("Switch");add("int");
        add("native");add("new");add("Else");
        add("delete");add("null");add("public");
        add("var");add("double");add("this ");
        add("long");add("package");add("float");
        add("Goto");add("private");add("class");
        add("if ");add("short");add("While");
        add("protected");add("with");add("debugger");
        add("case");add("Continue");add("volatile");
        add("interface");add("Instanceof");add("super");
        add("synchronized");add("throw");add("Extends");
        add("final");add("export");add("throws");
        add("Try");add("import");add("double");
    }};
 
    public final static String[] SPECIALS = {"<", "(", "[", "{", "\\", "^", "-", "=", "!", "|", "]", "}",
        ")", "?", "*", "+", ">", ",", ":", ";", "~", "€", "@", "#"};

}
