/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This file is part of terraml-commons project.
 *
 * This file incorporates work covered by
 * the following copyright and permission notices:
 *
 * Copyright (C) 2018 Terra Software Informatics LLC. | info@terrayazilim.com.tr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package terraml.commons.j2js;

import java.util.ArrayList;
import java.util.List;

/**
 * @author M.Çağrı Tepebaşılı - cagritepebasili [at] protonmail [dot] com
 * @version 1.0.2-SNAPSHOT
 */
public final class FunctionBuilder {

    private String objectName;
    private String name;
    private List<Parameter> parameters;

    private FunctionBuilder() {
    }
    
    /**
     * @return 
     */
    public static FunctionBuilder create() {
        return new FunctionBuilder();
    }
    
    /**
     * @return 
     */
    public Function build() {
        return new Function(this);
    }

    /**
     * @param objectName
     * @return 
     */
    public FunctionBuilder setObjectName(String objectName) {
        this.objectName = objectName;
        return this;
    }

    /**
     * @param name
     * @return 
     */
    public FunctionBuilder setName(String name) {
        this.name = name;
        return this;
    }
    
    /**
     * @param index
     * @param parameter
     * @return 
     */
    public FunctionBuilder setParameter(int index, Parameter parameter) {
        getParameters().add(index, parameter);
        return this;
    }
    
    /**
     * @param parameter
     * @return 
     */
    public FunctionBuilder setParameter(Parameter parameter) {
        getParameters().add(parameter);
        return this;
    }

    /**
     * @param parameters
     * @return 
     */
    public FunctionBuilder setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * @return 
     */
    public String getObjectName() {
        return objectName;
    }

    /**
     * @return 
     */
    public String getName() {
        return name;
    }

    /**
     * @return 
     */
    public List<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<>();
        }
        
        return parameters;
    }
}
