/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This file is part of terraml-commons project.
 *
 * This file incorporates work covered by
 * the following copyright and permission notices:
 *
 * Copyright (C) 2018 Terra Software Informatics LLC. | info@terrayazilim.com.tr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package terraml.commons.j2js;

import java.io.Serializable;
import java.util.Collection;

/**
 * @author M.Çağrı Tepebaşılı - cagritepebasili [at] protonmail [dot] com
 * @version 1.0.2-SNAPSHOT
 */
public class Function implements Serializable {

    private final String objectName;
    private final String name;
    private final Collection<Parameter> parameters;
    
    /**
     * @param objectName
     * @param name
     * @param parameters
     */
    public Function(String objectName, String name, Collection<Parameter> parameters) {
        this.objectName = objectName;
        this.name = name;
        this.parameters = parameters;
    }

    /**
     * @param builder 
     */
    public Function(FunctionBuilder builder) {
        this.objectName = builder.getObjectName();
        this.name = builder.getName();
        this.parameters = builder.getParameters();
    }
    
    /**
     * @param objectName
     * @param name
     * @param parameters
     * @return
     */
    public static Function of(String objectName, String name, Collection<Parameter> parameters) {
        return new Function(objectName, name, parameters);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();

        builder.append(objectName);
        builder.append(".");
        builder.append(name);
        builder.append("(");

        if (parameters == null) {
            builder.append(");");
            return builder.toString();
        }

        for (Parameter each : parameters) {
            builder.append(each);
            builder.append(",");
        }

        String string = builder.toString();
        if (string.endsWith(",")) {
            string = string.substring(0, string.length() - 1);
        }

        return string + ");";
    }

    /**
     * @param string
     * @return 
     */
    private static final boolean isNameValid(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        
        if (Character.isDigit(string.charAt(0))) {
            return false;
        }
        
        if (Validation.KEYWORDS.contains(string)) {
            return false;
        }
        
        
        for (String special : Validation.SPECIALS) {
            if (string.contains(special)) {
                return false;
            }
        }

        return true;
    }
    
    public boolean isObjectNameValid() {
        return isNameValid(getObjectName());
    }
    
    public boolean isNameValid() {
        return isNameValid(getName());
    }

    public String getObjectName() {
        return objectName;
    }

    public String getName() {
        return name;
    }

    public Collection<Parameter> getParameters() {
        return parameters;
    }
}
