/*
 * Decompiled with CFR 0.152.
 */
package terraml.algorithm.node;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class AVLNode<Q>
implements Comparator<Q>,
Serializable {
    private final Comparator<Q> comparator;
    private AVLNode<Q> parent;
    private AVLNode<Q> left;
    private AVLNode<Q> right;
    private Q data;
    private int height;
    private int balance;
    private List<Q> duplicates;

    public AVLNode(Comparator<Q> comp, AVLNode<Q> parent, Q data) {
        this.comparator = comp;
        this.parent = parent;
        this.data = data;
    }

    public AVLNode(Comparator<Q> comp, Q data) {
        this(comp, null, data);
    }

    public boolean hasDuplicates() {
        return Objects.nonNull(this.duplicates) && !this.duplicates.isEmpty();
    }

    public boolean addDuplicate(Q data) {
        if (terraml.commons.Objects.isNull(this.duplicates)) {
            this.duplicates = new ArrayList<Q>();
        }
        return this.duplicates.add(data);
    }

    @Override
    public int compare(Q o1, Q o2) {
        return this.comparator.compare(o1, o2);
    }

    public AVLNode<Q> getParent() {
        return this.parent;
    }

    public void setParent(AVLNode<Q> parent) {
        this.parent = parent;
    }

    public AVLNode<Q> getLeft() {
        return this.left;
    }

    public void setLeft(AVLNode<Q> left) {
        this.left = left;
    }

    public AVLNode<Q> getRight() {
        return this.right;
    }

    public void setRight(AVLNode<Q> right) {
        this.right = right;
    }

    public Q getData() {
        return this.data;
    }

    public void setData(Q data) {
        this.data = data;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getBalance() {
        return this.balance;
    }

    public void setBalance(int balance) {
        this.balance = balance;
    }

    public List<Q> getDuplicates() {
        return this.duplicates;
    }

    public void setDuplicates(List<Q> duplicates) {
        this.duplicates = duplicates;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + Objects.hashCode(this.comparator);
        hash = 71 * hash + Objects.hashCode(this.parent);
        hash = 71 * hash + Objects.hashCode(this.left);
        hash = 71 * hash + Objects.hashCode(this.right);
        hash = 71 * hash + Objects.hashCode(this.data);
        hash = 71 * hash + this.height;
        hash = 71 * hash + this.balance;
        hash = 71 * hash + Objects.hashCode(this.duplicates);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AVLNode other = (AVLNode)obj;
        if (this.height != other.height) {
            return false;
        }
        if (this.balance != other.balance) {
            return false;
        }
        if (!Objects.equals(this.comparator, other.comparator)) {
            return false;
        }
        if (!Objects.equals(this.parent, other.parent)) {
            return false;
        }
        if (!Objects.equals(this.left, other.left)) {
            return false;
        }
        if (!Objects.equals(this.right, other.right)) {
            return false;
        }
        if (!Objects.equals(this.data, other.data)) {
            return false;
        }
        return Objects.equals(this.duplicates, other.duplicates);
    }
}

