/*
 * Decompiled with CFR 0.152.
 */
package terraml.algorithm;

import java.io.Serializable;
import java.util.Objects;
import terraml.algorithm.GeoPoint;
import terraml.commons.Doubles;
import terraml.commons.tuple.Pair;

public class Quadrant
implements Serializable {
    private String data;
    private GeoPoint sw;
    private GeoPoint ne;

    public Quadrant(String data, GeoPoint sw, GeoPoint ne) {
        this.data = data;
        Pair<GeoPoint, GeoPoint> pair = Quadrant.boundsOf(sw, ne);
        this.sw = (GeoPoint)pair.key;
        this.ne = (GeoPoint)pair.value;
    }

    public Quadrant(GeoPoint sw, GeoPoint ne) {
        this(null, sw, ne);
    }

    public Quadrant(double x0, double y0, double x1, double y1) {
        this(new GeoPoint(x0, y0, 0.0), new GeoPoint(x1, y1, 0.0));
    }

    public Quadrant(String data, double x0, double y0, double x1, double y1) {
        this(data, new GeoPoint(x0, y0, 0.0), new GeoPoint(x1, y1, 0.0));
    }

    public static Pair<GeoPoint, GeoPoint> boundsOf(GeoPoint ... entries) {
        double _latMin = Double.POSITIVE_INFINITY;
        double _lonMin = Double.POSITIVE_INFINITY;
        double _latMax = Double.NEGATIVE_INFINITY;
        double _lonMax = Double.NEGATIVE_INFINITY;
        for (GeoPoint entry : entries) {
            _latMin = Math.min(_latMin, entry.getX());
            _latMax = Math.max(_latMax, entry.getX());
            _lonMin = Math.min(_lonMin, entry.getY());
            _lonMax = Math.max(_lonMax, entry.getY());
        }
        return new Pair((Object)new GeoPoint(_latMin, _lonMin), (Object)new GeoPoint(_latMax, _lonMax));
    }

    public static boolean contains(Quadrant quadrant, GeoPoint p0, GeoPoint p1) {
        Pair<GeoPoint, GeoPoint> pair = Quadrant.boundsOf(p0, p1);
        GeoPoint _sw = (GeoPoint)pair.key;
        GeoPoint _ne = (GeoPoint)pair.value;
        return Doubles.isGreaterEqual((double)_sw.getX(), (double)quadrant.getSw().getX()) && Doubles.isSmallerEqual((double)_ne.getX(), (double)quadrant.getNe().getX()) && Doubles.isGreaterEqual((double)_sw.getY(), (double)quadrant.getSw().getY()) && Doubles.isSmallerEqual((double)_ne.getY(), (double)quadrant.getNe().getY());
    }

    public static boolean contains(Quadrant quadrant, GeoPoint p0) {
        return Doubles.isGreaterEqual((double)p0.getX(), (double)quadrant.getSw().getX()) && Doubles.isGreaterEqual((double)p0.getY(), (double)quadrant.getSw().getY()) && Doubles.isSmallerEqual((double)p0.getX(), (double)quadrant.getNe().getX()) && Doubles.isSmallerEqual((double)p0.getY(), (double)quadrant.getNe().getY());
    }

    public static boolean intersects(Quadrant quadrant, GeoPoint p0, GeoPoint p1) {
        Pair<GeoPoint, GeoPoint> pair = Quadrant.boundsOf(p0, p1);
        GeoPoint _sw = (GeoPoint)pair.key;
        GeoPoint _ne = (GeoPoint)pair.value;
        return Doubles.isGreaterEqual((double)_ne.getX(), (double)quadrant.getSw().getX()) && Doubles.isSmallerEqual((double)_sw.getX(), (double)quadrant.getNe().getX()) && Doubles.isGreaterEqual((double)_ne.getY(), (double)quadrant.getSw().getY()) && Doubles.isSmallerEqual((double)_sw.getY(), (double)quadrant.getNe().getY());
    }

    public boolean intersects(GeoPoint p0, GeoPoint p1) {
        return Quadrant.intersects(this, p0, p1);
    }

    public boolean intersects(Quadrant quadrant) {
        return Quadrant.intersects(this, quadrant.getSw(), this.getNe());
    }

    public boolean contains(Quadrant quadrant) {
        return Quadrant.contains(this, quadrant.getSw(), quadrant.getNe());
    }

    public boolean contains(GeoPoint geoPoint) {
        return Quadrant.contains(this, geoPoint);
    }

    public boolean contains(GeoPoint p0, GeoPoint p1) {
        return Quadrant.contains(this, p0, p1);
    }

    public GeoPoint getCenter() {
        double lat = (this.getNe().getX() - this.getSw().getX()) * 0.5 + this.getSw().getX();
        double lon = (this.getNe().getY() - this.getSw().getY()) * 0.5 + this.getSw().getY();
        return new GeoPoint(lat, lon);
    }

    public GeoPoint getNw() {
        double lat = this.getNe().getX();
        double lon = this.getSw().getY();
        return new GeoPoint(lat, lon);
    }

    public GeoPoint getSe() {
        double lat = this.getSw().getX();
        double lon = this.getNe().getY();
        return new GeoPoint(lat, lon);
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public GeoPoint getSw() {
        return this.sw;
    }

    public void setSw(GeoPoint sw) {
        this.sw = sw;
    }

    public GeoPoint getNe() {
        return this.ne;
    }

    public void setNe(GeoPoint ne) {
        this.ne = ne;
    }

    public int hashCode() {
        int hash = 5;
        hash = 83 * hash + Objects.hashCode(this.data);
        hash = 83 * hash + Objects.hashCode(this.sw);
        hash = 83 * hash + Objects.hashCode(this.ne);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Quadrant other = (Quadrant)obj;
        if (!Objects.equals(this.data, other.data)) {
            return false;
        }
        if (!Objects.equals(this.sw, other.sw)) {
            return false;
        }
        return Objects.equals(this.ne, other.ne);
    }
}

