/*
 * Decompiled with CFR 0.152.
 */
package terraml.algorithm;

import java.util.Comparator;
import terraml.algorithm.GeoPoint;
import terraml.commons.math.Angle;

@FunctionalInterface
public interface LatlonComparator
extends Comparator<GeoPoint> {
    @Override
    public int compare(GeoPoint var1, GeoPoint var2);

    default public int compare(double x0, double y0, double x1, double y1) {
        return this.compare(new GeoPoint(x0, y0), new GeoPoint(x1, y1));
    }

    default public int latitudeDirectionCompare(GeoPoint p0, GeoPoint p1) {
        double angle = this.azimuth(p0, p1);
        if (angle > 0.0 && angle < 180.0) {
            return -1;
        }
        if (angle > 180.0 && angle < 360.0) {
            return 1;
        }
        if (angle == 0.0 || angle == 360.0 || angle == 180.0) {
            return 0;
        }
        return -2;
    }

    default public int longitudeDirectionCompare(GeoPoint p0, GeoPoint p1) {
        boolean isSouthEast;
        boolean isNorthEast;
        double angle = this.azimuth(p0, p1);
        boolean isNorthWest = angle > 0.0 && angle < 90.0;
        boolean bl = isNorthEast = angle > 270.0 && angle < 360.0;
        if (isNorthEast || isNorthWest) {
            return -1;
        }
        boolean isSouthWest = angle > 90.0 && angle < 180.0;
        boolean bl2 = isSouthEast = angle > 180.0 && angle < 270.0;
        if (isSouthEast || isSouthWest) {
            return 1;
        }
        if (angle == 90.0 || angle == 270.0) {
            return 0;
        }
        return -2;
    }

    default public double azimuth(GeoPoint from, GeoPoint to) {
        double lat0 = Math.toRadians(from.getX());
        double lon0 = Math.toRadians(from.getY());
        double lat1 = Math.toRadians(to.getX());
        double lon1 = Math.toRadians(to.getY());
        double _lat0 = lat0;
        double _lat1 = lat1;
        double _dlon = lon1 - lon0;
        double _letY = Math.sin(_dlon) * Math.cos(_lat1);
        double _letX = Math.cos(_lat0) * Math.sin(_lat1) - Math.sin(_lat0) * Math.cos(_lat1) * Math.cos(_dlon);
        double initBearing = Math.toDegrees(Math.atan2(_letY, _letX));
        double Q = (360.0 + initBearing) % 360.0;
        return Angle.fromDegree((double)Q).degree;
    }
}

