/*
 * Decompiled with CFR 0.152.
 */
package terraml.algorithm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import terraml.algorithm.DistanceCalc;
import terraml.algorithm.GeoPoint;
import terraml.algorithm.KDTree2Builder;
import terraml.algorithm.LatlonComparator;
import terraml.algorithm.Quadrant;
import terraml.algorithm.iterator.KDEnumerator;
import terraml.algorithm.node.KDNode2;
import terraml.commons.Objects;

public class KDTree2
implements Collection<GeoPoint>,
Iterable<GeoPoint> {
    public static final int K = 2;
    private DistanceCalc distanceCalc = new DistanceCalc(){

        @Override
        public double calc(GeoPoint p0, GeoPoint p1) {
            return this.vincenty(p0, p1);
        }
    };
    private Comparator<GeoPoint> xComparator = new LatlonComparator(){

        @Override
        public int compare(GeoPoint p0, GeoPoint p1) {
            return this.latitudeDirectionCompare(p0, p1);
        }
    };
    private Comparator<GeoPoint> yComparator = new LatlonComparator(){

        @Override
        public int compare(GeoPoint p0, GeoPoint p1) {
            return this.longitudeDirectionCompare(p0, p1);
        }
    };
    private KDNode2 root = null;

    private KDTree2(DistanceCalc calc, Comparator<GeoPoint> xComp, Comparator<GeoPoint> yComp) {
        if (Objects.nonNull((Object)calc)) {
            this.distanceCalc = calc;
        }
        if (Objects.nonNull(xComp)) {
            this.xComparator = xComp;
        }
        if (Objects.nonNull(yComp)) {
            this.yComparator = yComp;
        }
    }

    public KDTree2(KDTree2Builder builder) {
        this(builder.getDistanceCalc(), builder.getxComparator(), builder.getyComparator());
    }

    public KDTree2() {
        this(null, null, null);
    }

    protected KDNode2 add(KDNode2 source, GeoPoint geoPoint) {
        if (source == null) {
            return new KDNode2(geoPoint);
        }
        int cmp = this.order(source).compare(source.getCoordinate(), geoPoint);
        if (cmp <= 0) {
            source.setLeft(this.add(source.getLeft(), geoPoint));
            source.getLeft().setHeight(source.getHeight() + 1);
            source.getLeft().setParent(source);
        } else {
            source.setRight(this.add(source.getRight(), geoPoint));
            source.getRight().setHeight(source.getHeight() + 1);
            source.getRight().setParent(source);
        }
        return source;
    }

    @Override
    public boolean add(GeoPoint geoPoint) {
        if (this.getRoot() == null) {
            this.setRoot(new KDNode2(geoPoint, 0));
            return true;
        }
        this.setRoot(this.add(this.getRoot(), geoPoint));
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends GeoPoint> collection) {
        for (GeoPoint geoPoint : collection) {
            if (this.add(geoPoint)) continue;
            return false;
        }
        return true;
    }

    protected List<GeoPoint> query(KDNode2 source, Quadrant quadrant, List<GeoPoint> collector) {
        if (source == null) {
            return collector;
        }
        if (quadrant.contains(source.getCoordinate())) {
            collector.add(source.getCoordinate());
            collector = this.query(source.getLeft(), quadrant, collector);
            collector = this.query(source.getRight(), quadrant, collector);
        } else {
            int cmp = this.order(source).compare(source.getCoordinate(), quadrant.getCenter());
            if (cmp <= 0) {
                collector = this.query(source.getLeft(), quadrant, collector);
            } else if (cmp > 0) {
                collector = this.query(source.getRight(), quadrant, collector);
            }
        }
        return collector;
    }

    public List<GeoPoint> query(Quadrant quadrant) {
        KDNode2 ref = this.getRoot();
        return this.query(ref, quadrant, new ArrayList<GeoPoint>());
    }

    public List<GeoPoint> query(GeoPoint p0, GeoPoint p1) {
        return this.query(new Quadrant(p0, p1));
    }

    protected GeoPoint nearestNeighbor(KDNode2 source, GeoPoint target, GeoPoint found, double distance) {
        int cmp;
        if (source == null) {
            return null;
        }
        double reference = distance;
        double tmp = this.distanceCalc.calc(source.getCoordinate(), target);
        if (tmp < distance) {
            found = source.getCoordinate();
            reference = tmp;
        }
        if ((cmp = this.order(source).compare(source.getCoordinate(), target)) <= 0) {
            if (source.getLeft() == null) {
                return found;
            }
            return this.nearestNeighbor(source.getLeft(), target, found, reference);
        }
        if (cmp > 0) {
            if (source.getRight() == null) {
                return found;
            }
            return this.nearestNeighbor(source.getRight(), target, found, reference);
        }
        return null;
    }

    public GeoPoint nearestNeighbor(GeoPoint geoPoint) {
        if (this.getRoot() == null) {
            return null;
        }
        return this.nearestNeighbor(this.getRoot(), geoPoint, null, Double.MAX_VALUE);
    }

    protected List<GeoPoint> distinct(KDNode2 src, List<GeoPoint> collector) {
        if (src == null) {
            return collector;
        }
        if (Objects.nonNull((Object)src.getCoordinate())) {
            collector.add(src.getCoordinate());
        }
        collector = this.distinct(src.getLeft(), collector);
        collector = this.distinct(src.getRight(), collector);
        return collector;
    }

    public Enumeration<GeoPoint> enumeration() {
        KDNode2 ref = this.getRoot();
        return new KDEnumerator(ref);
    }

    @Override
    public Iterator<GeoPoint> iterator() {
        KDNode2 ref = this.getRoot();
        return this.distinct(ref, new ArrayList<GeoPoint>()).iterator();
    }

    public List<GeoPoint> list() {
        KDNode2 ref = this.getRoot();
        return this.distinct(ref, new ArrayList<GeoPoint>());
    }

    protected KDNode2 getNode(KDNode2 source, GeoPoint geoPoint) {
        if (source == null) {
            return null;
        }
        int cmp = this.order(source).compare(source.getCoordinate(), geoPoint);
        if (source.getCoordinate().equals(geoPoint)) {
            return source;
        }
        if (cmp < 0) {
            return this.getNode(source.getLeft(), geoPoint);
        }
        if (cmp > 0) {
            return this.getNode(source.getRight(), geoPoint);
        }
        return null;
    }

    public GeoPoint get(GeoPoint geoPoint) {
        if (this.getRoot() == null) {
            return null;
        }
        return this.getNode(this.getRoot(), geoPoint).getCoordinate();
    }

    @Override
    public boolean contains(Object geoPoint) {
        if (this.getRoot() == null) {
            return false;
        }
        return this.getNode(this.getRoot(), (GeoPoint)geoPoint) != null;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object each : collection) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    protected Comparator<GeoPoint> order(KDNode2 node) {
        if (node.getHeight() % 2 == 0) {
            return this.xComparator;
        }
        if (node.getHeight() % 2 == 1) {
            return this.yComparator;
        }
        throw new IllegalStateException("cannot happen");
    }

    protected int size(KDNode2 source) {
        if (source == null) {
            return 0;
        }
        return 1 + this.size(source.getLeft()) + this.size(source.getRight());
    }

    @Override
    public int size() {
        if (this.getRoot() == null) {
            return 0;
        }
        return this.size(this.getRoot());
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object[] toArray() {
        return this.distinct(this.getRoot(), new ArrayList<GeoPoint>()).toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.distinct(this.getRoot(), new ArrayList<GeoPoint>()).toArray(a);
    }

    @Override
    public void clear() {
        this.setRoot(null);
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected int height(KDNode2 source) {
        if (source == null) {
            return 0;
        }
        return 1 + Math.max(this.height(source.getLeft()), this.height(source.getRight()));
    }

    public int height() {
        if (this.getRoot() == null) {
            return 0;
        }
        return this.height(this.getRoot());
    }

    public void setRoot(KDNode2 root) {
        this.root = root;
    }

    public KDNode2 getRoot() {
        return this.root;
    }

    public Comparator<GeoPoint> getxComparator() {
        return this.xComparator;
    }

    public Comparator<GeoPoint> getyComparator() {
        return this.yComparator;
    }

    public DistanceCalc getDistanceCalc() {
        return this.distanceCalc;
    }
}

