/*
 * Decompiled with CFR 0.152.
 */
package terraml.algorithm;

import terraml.algorithm.GeoPoint;

@FunctionalInterface
public interface DistanceCalc {
    public double calc(GeoPoint var1, GeoPoint var2);

    default public double calc(double x0, double y0, double x1, double y1) {
        return this.calc(new GeoPoint(x0, y0), new GeoPoint(x1, y1));
    }

    default public double vincenty(GeoPoint p0, GeoPoint p1) {
        return this.vincenty(p0.getX(), p0.getY(), p1.getX(), p1.getY());
    }

    default public double vincenty(double x0, double y0, double x1, double y1) {
        double lat0 = Math.toRadians(x0);
        double lon0 = Math.toRadians(y0);
        double lat1 = Math.toRadians(x1);
        double lon1 = Math.toRadians(y1);
        return this.vincentyFromRadian(lat0, lon0, lat1, lon1);
    }

    default public double vincentyFromRadian(double lat0, double lon0, double lat1, double lon1) {
        double lambdaP;
        double cosSigma;
        double cos2SigmaM;
        double sinSigma;
        double sigma;
        double sinAlpha;
        double cosSqAlpha;
        double C;
        double a = 6378137.0;
        double b = 6356752.314245;
        double f = 0.0033528106647474805;
        double L = lon1 - lon0;
        double U1 = Math.atan((1.0 - f) * Math.tan(lat0));
        double U2 = Math.atan((1.0 - f) * Math.tan(lat1));
        double sinU1 = Math.sin(U1);
        double cosU1 = Math.cos(U1);
        double sinU2 = Math.sin(U2);
        double cosU2 = Math.cos(U2);
        double lambda = L;
        double iterLimit = 100.0;
        do {
            double cosLambda;
            double sinLambda;
            if ((sinSigma = Math.sqrt(cosU2 * (sinLambda = Math.sin(lambda)) * (cosU2 * sinLambda) + (cosU1 * sinU2 - sinU1 * cosU2 * (cosLambda = Math.cos(lambda))) * (cosU1 * sinU2 - sinU1 * cosU2 * cosLambda))) == 0.0) {
                return 0.0;
            }
            cosSigma = sinU1 * sinU2 + cosU1 * cosU2 * cosLambda;
            sigma = Math.atan2(sinSigma, cosSigma);
            sinAlpha = cosU1 * cosU2 * sinLambda / sinSigma;
            cosSqAlpha = 1.0 - sinAlpha * sinAlpha;
            cos2SigmaM = cosSigma - 2.0 * sinU1 * sinU2 / cosSqAlpha;
            if (!Double.isNaN(cos2SigmaM)) continue;
            cos2SigmaM = 0.0;
        } while (Math.abs((lambda = L + (1.0 - (C = f / 16.0 * cosSqAlpha * (4.0 + f * (4.0 - 3.0 * cosSqAlpha)))) * f * sinAlpha * (sigma + C * sinSigma * (cos2SigmaM + C * cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM)))) - (lambdaP = lambda)) > 1.0E-12 && (iterLimit -= 1.0) > 0.0);
        if (iterLimit == 0.0) {
            return Double.NaN;
        }
        double uSq = cosSqAlpha * (a * a - b * b) / (b * b);
        double A = 1.0 + uSq / 16384.0 * (4096.0 + uSq * (-768.0 + uSq * (320.0 - 175.0 * uSq)));
        double B = uSq / 1024.0 * (256.0 + uSq * (-128.0 + uSq * (74.0 - 47.0 * uSq)));
        double deltaSigma = B * sinSigma * (cos2SigmaM + B / 4.0 * (cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM) - B / 6.0 * cos2SigmaM * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SigmaM * cos2SigmaM)));
        return b * A * (sigma - deltaSigma);
    }
}

