/*
 * Decompiled with CFR 0.152.
 */
package terraml.algorithm;

import java.util.Iterator;
import java.util.LinkedList;
import terraml.algorithm.DisjointNode;

public final class DisjointSets {
    private DisjointSets() {
    }

    public static <G> Iterator<G> iterator(DisjointNode<G> disjointNode) {
        LinkedList<G> linkedlist = new LinkedList<G>();
        DisjointNode<G> reference = disjointNode;
        while (reference.getParent() != null && !reference.getParent().equals(reference)) {
            linkedlist.add(reference.getObject());
            reference = reference.getParent();
        }
        return linkedlist.iterator();
    }

    public static <G> DisjointNode<G> make(G element) {
        DisjointNode<G> disjointNode = new DisjointNode<G>(element);
        disjointNode.setParent(disjointNode);
        return disjointNode;
    }

    public static <G> DisjointNode<G> find(DisjointNode<G> disjointNode) {
        if (!disjointNode.getParent().equals(disjointNode)) {
            DisjointNode<G> tmpNode = DisjointSets.find(disjointNode.getParent());
            disjointNode.setParent(tmpNode);
        }
        return disjointNode.getParent();
    }

    public static <G> DisjointNode<G> union(DisjointNode<G> x, DisjointNode<G> y) {
        DisjointNode<G> node0 = DisjointSets.find(x);
        DisjointNode<G> node1 = DisjointSets.find(y);
        if (node0 == null && node1 == null) {
            return null;
        }
        if (node0 == null) {
            return node1;
        }
        if (node1 == null) {
            return node0;
        }
        if (node0.compareTo(node1) < 0) {
            node0.setParent(node1);
            return node1;
        }
        if (node0.compareTo(node1) > 0) {
            node1.setParent(node0);
            return node0;
        }
        node1.setParent(node0);
        node0.increment();
        return node0;
    }
}

