/*
 * Decompiled with CFR 0.152.
 */
package terraml.algorithm;

import java.io.Serializable;
import java.util.Objects;

public class DisjointNode<Q>
implements Comparable<DisjointNode<Q>>,
Serializable {
    protected DisjointNode<Q> parent;
    protected Q object;
    protected int rank = 0;

    public DisjointNode() {
    }

    public DisjointNode(Q object) {
        this.object = object;
    }

    public void increment() {
        this.setRank(this.getRank() + 1);
    }

    public DisjointNode<Q> getParent() {
        return this.parent;
    }

    public void setParent(DisjointNode<Q> parent) {
        this.parent = parent;
    }

    public Q getObject() {
        return this.object;
    }

    public void setObject(Q object) {
        this.object = object;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    @Override
    public int compareTo(DisjointNode<Q> o) {
        return this.getRank() - o.getRank();
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.parent);
        hash = 67 * hash + Objects.hashCode(this.object);
        hash = 67 * hash + this.rank;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DisjointNode other = (DisjointNode)obj;
        if (this.rank != other.rank) {
            return false;
        }
        if (!Objects.equals(this.parent, other.parent)) {
            return false;
        }
        return Objects.equals(this.object, other.object);
    }
}

