/*
 * Decompiled with CFR 0.152.
 */
package terraml.algorithm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import terraml.algorithm.DefaultWeightedEdge;
import terraml.algorithm.DijkstraVertex;
import terraml.commons.Doubles;
import terraml.commons.Objects;

public class Dijkstra<Q> {
    private final HashMap<Q, DijkstraVertex<Q>> graph;

    private Dijkstra(HashMap<Q, DijkstraVertex<Q>> graph) {
        this.graph = graph;
    }

    public static <Q> Dijkstra<Q> create(Collection<DefaultWeightedEdge<Q>> edgeCollection) {
        return new Dijkstra<Q>(Dijkstra.init(edgeCollection));
    }

    private static <Q> HashMap<Q, DijkstraVertex<Q>> init(Collection<DefaultWeightedEdge<Q>> edgeCollection) {
        HashMap<Q, DijkstraVertex<Q>> newGraph = new HashMap<Q, DijkstraVertex<Q>>(edgeCollection.size());
        for (DefaultWeightedEdge<Q> currentEdge : edgeCollection) {
            boolean hasTarget;
            Q object = currentEdge.getSource();
            boolean hasSource = Objects.nonNull(newGraph.get(object));
            if (!hasSource) {
                newGraph.put(object, new DijkstraVertex<Q>(object));
            }
            if (hasTarget = Objects.nonNull(newGraph.get(object = currentEdge.getTarget()))) continue;
            newGraph.put(object, new DijkstraVertex<Q>(object));
        }
        for (DefaultWeightedEdge<Q> currentEdge : edgeCollection) {
            Q src = currentEdge.getSource();
            Q tar = currentEdge.getTarget();
            DijkstraVertex object = (DijkstraVertex)newGraph.get(tar);
            ((DijkstraVertex)newGraph.get(src)).getConnections().put(object, currentEdge.getWeight());
        }
        return newGraph;
    }

    public List<Map.Entry<Q, Double>> path() {
        ArrayList<Map.Entry<Q, Double>> list = new ArrayList<Map.Entry<Q, Double>>();
        for (DijkstraVertex<Q> vertex : this.graph.values()) {
            list.add(vertex.toEntry());
        }
        return list;
    }

    public void dijkstra(Q pointer) throws NoSuchElementException {
        if (Objects.isNull(this.graph.get(pointer))) {
            throw new NoSuchElementException("Given start pointer is not found in the graph");
        }
        DijkstraVertex<Q> source = this.graph.get(pointer);
        TreeSet<DijkstraVertex<Q>> navigableSet = new TreeSet<DijkstraVertex<Q>>();
        for (DijkstraVertex<Q> current : this.graph.values()) {
            current.setPrevious(current == source ? source : null);
            current.setWeight(current == source ? 0.0 : Double.MAX_VALUE);
            navigableSet.add(current);
        }
        this.dijkstra((NavigableSet<DijkstraVertex<Q>>)navigableSet);
    }

    protected void dijkstra(NavigableSet<DijkstraVertex<Q>> navigable) {
        DijkstraVertex<Q> front;
        while (!navigable.isEmpty() && !Doubles.isEqual((double)(front = navigable.pollFirst()).getWeight(), (double)Double.MAX_VALUE)) {
            for (Map.Entry<DijkstraVertex<Q>, Double> entry : front.getConnections().entrySet()) {
                DijkstraVertex<Q> rear = entry.getKey();
                double alternative = front.getWeight() + entry.getValue();
                if (!(alternative < rear.getWeight())) continue;
                navigable.remove(rear);
                rear.setWeight(alternative);
                rear.setPrevious(front);
                navigable.add(rear);
            }
        }
    }

    public HashMap<Q, DijkstraVertex<Q>> getGraph() {
        return this.graph;
    }
}

