/*
 * Decompiled with CFR 0.152.
 */
package terraml.algorithm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import terraml.algorithm.BiTreeSet;
import terraml.algorithm.iterator.AVLOrderedTraversal;
import terraml.algorithm.node.AVLNode;
import terraml.commons.Objects;

public class AVLSearch<Q>
implements BiTreeSet<Q> {
    private final Comparator<Q> comparator;
    private AVLNode<Q> root;

    public AVLSearch(Comparator<Q> comparator) {
        this.comparator = comparator;
    }

    public AVLSearch(Comparator<Q> comparator, AVLNode<Q> root) {
        this(comparator);
        this.root = root;
    }

    public AVLSearch(Comparator<Q> comparator, Q data) {
        this((Comparator<AVLNode<Q>>)comparator, new AVLNode<Q>(comparator, data));
    }

    @Override
    public boolean add(Q data) {
        AVLNode<Q> parent;
        boolean lefty;
        if (Objects.isNull(this.getRoot())) {
            this.setRoot(new AVLNode<Q>(this.getComparator(), null, data));
            return true;
        }
        AVLNode<Q> reference = this.getRoot();
        do {
            if (this.eq(data, (Q)reference)) {
                return reference.addDuplicate(data);
            }
            parent = reference;
        } while (!Objects.isNull(reference = (lefty = this.st(data, (Q)reference)) ? reference.getLeft() : reference.getRight()));
        if (lefty) {
            parent.setLeft(new AVLNode<Q>(this.getComparator(), parent, data));
        } else {
            parent.setRight(new AVLNode<Q>(this.getComparator(), parent, data));
        }
        this.rebalance(parent);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Q> collection) {
        for (Q each : collection) {
            if (this.add(each)) continue;
            return false;
        }
        return true;
    }

    protected boolean contains(AVLNode<Q> src, Q data) {
        if (Objects.isNull(src)) {
            return false;
        }
        if (this.eq(data, (Q)src)) {
            if (data.equals(src.getData())) {
                return true;
            }
            if (src.hasDuplicates()) {
                for (Q each : src.getDuplicates()) {
                    if (!data.equals(each)) continue;
                    return true;
                }
            }
        }
        if (this.st(data, (Q)src)) {
            return this.contains(src.getLeft(), data);
        }
        if (this.gt(data, (Q)src)) {
            return this.contains(src.getRight(), data);
        }
        return false;
    }

    @Override
    public boolean contains(Object object) {
        AVLNode<Q> ref = this.getRoot();
        return this.contains(ref, object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object each : collection) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    protected boolean containsFamily(AVLNode<Q> src, Q data) {
        if (Objects.isNull(src)) {
            return false;
        }
        if (this.eq(data, (Q)src)) {
            return true;
        }
        if (this.st(data, (Q)src)) {
            return this.contains(src.getLeft(), data);
        }
        if (this.gt(data, (Q)src)) {
            return this.contains(src.getRight(), data);
        }
        return false;
    }

    @Override
    public boolean containsFamily(Q object) {
        AVLNode<Q> ref = this.getRoot();
        return this.containsFamily(ref, object);
    }

    @Override
    public boolean containsAllFamily(Collection<Q> collection) {
        for (Q each : collection) {
            if (this.containsFamily(each)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void removeFamily(Q object) {
        if (Objects.isNull(this.getRoot())) {
            return;
        }
        AVLNode<Q> child = this.getRoot();
        while (Objects.nonNull(child)) {
            AVLNode<Q> node = child;
            AVLNode<Q> aVLNode = child = this.gt(object, node.getData()) ? node.getRight() : node.getLeft();
            if (!this.eq(object, (Q)node)) continue;
            this._removeFamily(node);
        }
    }

    @Override
    public void removeAllFamily(Collection<? extends Q> collection) {
        for (Q each : collection) {
            this.removeFamily(each);
        }
    }

    @Override
    public boolean removeIf(Predicate<? super Q> filter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected void _removeFamily(AVLNode<Q> node) {
        if (this.lf(node)) {
            if (Objects.isNull(node.getParent())) {
                if (this.getRoot().equals(node)) {
                    this.setRoot(null);
                }
            } else {
                AVLNode parent = node.getParent();
                if (this.eq((Q)parent.getLeft(), (Q)node)) {
                    parent.setLeft(null);
                } else {
                    parent.setRight(null);
                }
                this.rebalance(parent);
            }
            return;
        }
        if (!this.lf(node)) {
            AVLNode<Q> child = node.getLeft();
            while (!this.re(child)) {
                child = child.getRight();
            }
            node.setData(child.getData());
            this._removeFamily(child);
        } else {
            AVLNode<Q> child = node.getRight();
            while (!this.le(child)) {
                child = child.getLeft();
            }
            node.setData(child.getData());
            this._removeFamily(child);
        }
    }

    protected void rebalance(AVLNode<Q> node) {
        this.setBalance(Arrays.asList(node));
        if (node.getBalance() == -2) {
            node = this.height(node.getLeft().getLeft()) >= this.height(node.getLeft().getRight()) ? this.rotateRight(node) : this.rotateLeftThenRight(node);
        } else if (node.getBalance() == 2) {
            node = this.height(node.getRight().getRight()) >= this.height(node.getRight().getLeft()) ? this.rotateLeft(node) : this.rotateRightThenLeft(node);
        }
        if (Objects.nonNull(node.getParent())) {
            this.rebalance(node.getParent());
        } else {
            this.setRoot(node);
        }
    }

    protected AVLNode<Q> rotateLeft(AVLNode<Q> node) {
        AVLNode<Q> reference = node.getRight();
        reference.setParent(node.getParent());
        node.setRight(reference.getLeft());
        if (Objects.nonNull(node.getRight())) {
            node.getRight().setParent(node);
        }
        reference.setLeft(node);
        node.setParent(reference);
        if (Objects.nonNull(reference.getParent())) {
            if (Objects.isNull(reference.getParent().getRight())) {
                reference.getParent().setLeft(reference);
            } else if (reference.getParent().getRight().equals(node)) {
                reference.getParent().setRight(reference);
            } else {
                reference.getParent().setLeft(reference);
            }
        }
        this.setBalance(Arrays.asList(node, reference));
        return reference;
    }

    protected AVLNode<Q> rotateRight(AVLNode<Q> node) {
        AVLNode<Q> reference = node.getLeft();
        reference.setParent(node.getParent());
        node.setLeft(reference.getRight());
        if (Objects.nonNull(node.getLeft())) {
            node.getLeft().setParent(node);
        }
        reference.setRight(node);
        node.setParent(reference);
        if (Objects.nonNull(reference.getParent())) {
            if (Objects.isNull(reference.getParent().getRight())) {
                reference.getParent().setLeft(reference);
            } else if (reference.getParent().getRight().equals(node)) {
                reference.getParent().setRight(reference);
            } else {
                reference.getParent().setLeft(reference);
            }
        }
        this.setBalance(Arrays.asList(node, reference));
        return reference;
    }

    protected AVLNode<Q> rotateLeftThenRight(AVLNode<Q> node) {
        node.setLeft(this.rotateLeft(node.getLeft()));
        return this.rotateRight(node);
    }

    protected AVLNode<Q> rotateRightThenLeft(AVLNode<Q> node) {
        node.setRight(this.rotateRight(node.getRight()));
        return this.rotateLeft(node);
    }

    protected Q minimum(AVLNode<Q> src) {
        if (this.le(src)) {
            return src.getData();
        }
        return this.minimum(src.getLeft());
    }

    protected Q maximum(AVLNode<Q> src) {
        if (this.re(src)) {
            return src.getData();
        }
        return this.maximum(src.getRight());
    }

    @Override
    public Q last() {
        return this.maximum(this.getRoot());
    }

    @Override
    public Q first() {
        return this.minimum(this.getRoot());
    }

    protected AVLNode<Q> minimumFamily(AVLNode<Q> src) {
        if (this.le(src)) {
            return src;
        }
        return this.minimumFamily(src.getLeft());
    }

    protected AVLNode<Q> maximumFamily(AVLNode<Q> src) {
        if (this.re(src)) {
            return src;
        }
        return this.maximumFamily(src.getRight());
    }

    @Override
    public Iterator<Q> lastFamily() {
        AVLNode<Q> bi = this.minimumFamily(this.getRoot());
        ArrayList<Q> list = new ArrayList<Q>();
        list.add(bi.getData());
        if (bi.hasDuplicates()) {
            for (Q each : bi.getDuplicates()) {
                list.add(each);
            }
        }
        return list.iterator();
    }

    @Override
    public Iterator<Q> firstFamily() {
        AVLNode<Q> bi = this.maximumFamily(this.getRoot());
        ArrayList<Q> list = new ArrayList<Q>();
        list.add(bi.getData());
        if (bi.hasDuplicates()) {
            for (Q each : bi.getDuplicates()) {
                list.add(each);
            }
        }
        return list.iterator();
    }

    protected AVLNode<Q> tailSet(AVLNode<Q> src, Q item) {
        if (src == null) {
            return null;
        }
        while ((this.eq(item, (Q)src) || this.gt(item, (Q)src)) && src != null) {
            src = this.tailSet(src.getRight(), item);
        }
        if (this.st(item, (Q)src)) {
            src.setLeft(this.tailSet(src.getLeft(), item));
        }
        return src;
    }

    @Override
    public SortedSet<Q> tailSet(Q fromElement) {
        AVLNode<Q> bi = this.getRoot();
        bi = this.tailSet(bi, fromElement);
        return new AVLSearch<AVLNode<Q>>(this.comparator, bi);
    }

    protected AVLNode<Q> headSet(AVLNode<Q> src, Q item) {
        if (src == null) {
            return null;
        }
        while ((this.eq(item, (Q)src) || this.st(item, (Q)src)) && src != null) {
            src = this.headSet(src.getLeft(), item);
        }
        if (this.gt(item, (Q)src)) {
            src.setRight(this.headSet(src.getRight(), item));
        }
        return src;
    }

    @Override
    public SortedSet<Q> headSet(Q toElement) {
        AVLNode<Q> bi = this.getRoot();
        bi = this.headSet(bi, toElement);
        return new AVLSearch<AVLNode<Q>>(this.comparator, bi);
    }

    protected AVLNode<Q> subSet(AVLNode<Q> src, Q from, Q to) {
        if (src == null) {
            return null;
        }
        if (this.st(to, (Q)src)) {
            return this.subSet(src.getLeft(), from, to);
        }
        if (this.gt(from, (Q)src)) {
            return this.subSet(src.getRight(), from, to);
        }
        src.setLeft(this.subSet(src.getLeft(), from, to));
        src.setRight(this.subSet(src.getRight(), from, to));
        return src;
    }

    @Override
    public SortedSet<Q> subSet(Q fromElement, Q toElement) {
        AVLNode<Q> bi = this.getRoot();
        bi = this.subSet(bi, fromElement, toElement);
        return new AVLSearch<AVLNode<Q>>(this.comparator, bi);
    }

    protected List<Q> collect(AVLNode<Q> src, List<Q> list) {
        if (src == null) {
            return list;
        }
        list.add(src.getData());
        if (src.hasDuplicates()) {
            for (Q each : src.getDuplicates()) {
                list.add(each);
            }
        }
        list = this.collect(src.getLeft(), list);
        list = this.collect(src.getRight(), list);
        return list;
    }

    protected int size(AVLNode<Q> src) {
        if (src == null) {
            return 0;
        }
        int count = 1;
        if (src.hasDuplicates()) {
            count += src.getDuplicates().size();
        }
        return count + this.size(src.getLeft()) + this.size(src.getRight());
    }

    @Override
    public int size() {
        return this.size(this.getRoot());
    }

    @Override
    public Spliterator<Q> spliterator() {
        return this.collect(this.getRoot(), new ArrayList()).spliterator();
    }

    @Override
    public Comparator<? super Q> comparator() {
        return this.comparator;
    }

    @Override
    public void clear() {
        this.setRoot(null);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.collect(this.getRoot(), new ArrayList()).toArray(a);
    }

    @Override
    public Object[] toArray() {
        return this.collect(this.getRoot(), new ArrayList()).toArray();
    }

    @Override
    public Iterator<Q> iterator() {
        return new AVLOrderedTraversal<Q>(this.getRoot());
    }

    @Override
    public boolean isEmpty() {
        return Objects.isNull(this.getRoot());
    }

    @Override
    public Stream<Q> parallelStream() {
        return this.collect(this.getRoot(), new ArrayList()).parallelStream();
    }

    @Override
    public Stream<Q> stream() {
        return this.collect(this.getRoot(), new ArrayList()).stream();
    }

    @Override
    public void forEach(Consumer<? super Q> action) {
        this.collect(this.getRoot(), new ArrayList()).forEach(action);
    }

    protected void setBalance(Collection<AVLNode<Q>> nodes) {
        for (AVLNode<Q> each : nodes) {
            this.reheight(each);
            int balance = this.height(each.getRight()) - this.height(each.getLeft());
            each.setBalance(balance);
        }
    }

    protected boolean eq(AVLNode<Q> src, AVLNode<Q> tar) {
        return src != null && tar != null && this.comparator.compare(src.getData(), tar.getData()) == 0;
    }

    protected boolean eq(Q data, AVLNode<Q> src) {
        return data != null && src != null && this.comparator.compare(data, src.getData()) == 0;
    }

    protected boolean eq(Q data0, Q data1) {
        return data0 != null && data1 != null && this.comparator.compare(data0, data1) == 0;
    }

    protected boolean st(AVLNode<Q> src, AVLNode<Q> tar) {
        return src != null && tar != null && this.comparator.compare(src.getData(), tar.getData()) < 0;
    }

    protected boolean st(Q data, AVLNode<Q> src) {
        return data != null && src != null && this.comparator.compare(data, src.getData()) < 0;
    }

    protected boolean st(Q data0, Q data1) {
        return data0 != null && data1 != null && this.comparator.compare(data0, data1) < 0;
    }

    protected boolean gt(AVLNode<Q> src, AVLNode<Q> tar) {
        return src != null && tar != null && this.comparator.compare(src.getData(), tar.getData()) > 0;
    }

    protected boolean gt(Q data, AVLNode<Q> src) {
        return data != null && src != null && this.comparator.compare(data, src.getData()) > 0;
    }

    protected boolean gt(Q data0, Q data1) {
        return data0 != null && data1 != null && this.comparator.compare(data0, data1) > 0;
    }

    protected boolean le(AVLNode<Q> src) {
        return src != null && src.getLeft() == null;
    }

    protected boolean re(AVLNode<Q> src) {
        return src != null && src.getRight() == null;
    }

    protected boolean lf(AVLNode<Q> src) {
        return src != null && src.getLeft() == null && src.getRight() == null;
    }

    protected int height(AVLNode<Q> node) {
        if (node == null) {
            return -1;
        }
        return node.getHeight();
    }

    protected void reheight(AVLNode<Q> node) {
        if (Objects.nonNull(node)) {
            int hg = 1 + Math.max(this.height(node.getLeft()), this.height(node.getRight()));
            node.setHeight(hg);
        }
    }

    public Comparator<Q> getComparator() {
        return this.comparator;
    }

    public AVLNode<Q> getRoot() {
        return this.root;
    }

    public void setRoot(AVLNode<Q> root) {
        this.root = root;
    }
}

