/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This file is part of terraml-algorithm project.
 *
 * This file incorporates work covered by
 * the following copyright and permission notices:
 *
 * Copyright (C) 2018 Terra Software Informatics LLC. | info [at] terrayazilim [dot] com [dot] tr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package terraml.algorithm.iterator;

import java.util.Enumeration;
import java.util.LinkedList;
import terraml.algorithm.GeoPoint;
import terraml.algorithm.node.KDNode2;

/**
 * @author M.Çağrı Tepebaşılı - cagritepebasili [at] protonmail [dot] com
 * @version 1.0.0-SNAPSHOT
 */
public class KDEnumerator implements Enumeration<GeoPoint> {

    private final LinkedList<KDNode2> linkedList = new LinkedList<>();

    /**
     * @param ref
     */
    public KDEnumerator(KDNode2 ref) {
        KDNode2 instance = ref;

        for ( KDNode2 current = instance; current != null; current = current.getLeft() ) {
            this.linkedList.push(current);
        }
    }

    @Override
    public boolean hasMoreElements() {
        return !linkedList.isEmpty();
    }

    @Override
    public GeoPoint nextElement() {
        KDNode2 current = linkedList.pop();

        for ( KDNode2 child = current.getRight(); child != null; child = child.getLeft() ) {
            linkedList.push(child);
        }

        return current.getCoordinate();
    }

}
