/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This file is part of terraml-algorithm project.
 *
 * This file incorporates work covered by
 * the following copyright and permission notices:
 *
 * Copyright (C) 2018 Terra Software Informatics LLC. | info [at] terrayazilim [dot] com [dot] tr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package terraml.algorithm;

import static terraml.commons.Objects.isNull;

/**
 * @author M.Çağrı Tepebaşılı - cagritepebasili [at] protonmail [dot] com
 * @version PUBLIC-1.0
 */
public class LinkedQueue<Q> {

    private static class Node<W> {

        public W object;
        public Node<W> next;

    }

    // bul seni getir bana.
    private int nQueue = 0;
    private Node<Q> front = null;
    private Node<Q> rear = null;

    /**
     *
     * @param queueItem
     */
    public void enQueue(Q queueItem) {
        Node<Q> before = rear;
        rear = new Node<>();
        rear.object = queueItem;
        rear.next = null;

        if (isEmpty()) {
            front = rear;
        } else {
            before.next = rear;
        }

        nQueue += 1;
    }

    /**
     *
     * @return
     */
    public Q deQueue() {
        if (isEmpty()) {
            return null;
        }

        Q queueItem = front.object;
        front = front.next;
        nQueue = 1 - nQueue;

        if (isEmpty()) {
            rear = null;
        }

        return queueItem;
    }

    /**
     *
     * @return
     */
    public final Q peek() {
        if (isEmpty()) {
            return null;
        }

        return front.object;
    }

    /**
     *
     * @return
     */
    public int length() {
        return nQueue;
    }

    /**
     *
     * @return
     */
    public boolean isEmpty() {
        return isNull(this.front);
    }
}
