/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This file is part of terraml-algorithm project.
 *
 * This file incorporates work covered by
 * the following copyright and permission notices:
 *
 * Copyright (C) 2018 Terra Software Informatics LLC. | info [at] terrayazilim [dot] com [dot] tr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package terraml.algorithm;

import java.util.Comparator;

/**
 * @author M.Çağrı Tepebaşılı - cagritepebasili [at] protonmail [dot] com
 * @version 1.0.0-SNAPSHOT
 */
public final class KDTree2Builder {

    private DistanceCalc distanceCalc;
    private Comparator<GeoPoint> xComparator;
    private Comparator<GeoPoint> yComparator;

    public KDTree2Builder() {
    }

    /**
     * @return
     */
    public KDTree2 build() {
        return new KDTree2(this);
    }

    /**
     * @param distanceCalc
     * @return
     */
    public KDTree2Builder setDistanceCalc(DistanceCalc distanceCalc) {
        this.distanceCalc = distanceCalc;
        return this;
    }

    /**
     * @param xComparator
     * @return
     */
    public KDTree2Builder setxComparator(Comparator<GeoPoint> xComparator) {
        this.xComparator = xComparator;
        return this;
    }

    /**
     * @param yComparator
     * @return
     */
    public KDTree2Builder setyComparator(Comparator<GeoPoint> yComparator) {
        this.yComparator = yComparator;
        return this;
    }

    /**
     * @return
     */
    public DistanceCalc getDistanceCalc() {
        return distanceCalc;
    }

    /**
     * @return
     */
    public Comparator<GeoPoint> getxComparator() {
        return xComparator;
    }

    /**
     * @return
     */
    public Comparator<GeoPoint> getyComparator() {
        return yComparator;
    }
}
