/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This file is part of terraml-algorithm project.
 *
 * This file incorporates work covered by
 * the following copyright and permission notices:
 *
 * Copyright (C) 2018 Terra Software Informatics LLC. | info [at] terrayazilim [dot] com [dot] tr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package terraml.algorithm;

import java.util.HashMap;
import java.util.Map;
import terraml.commons.tuple.NativeEntry;

/**
 * @author M.Çağrı Tepebaşılı - cagritepebasili [at] protonmail [dot] com
 * @version PUBLIC-1.0
 */
public class DijkstraVertex<Q> implements WeightedVertex<Q> {

    private Q id;
    private Double weight = Double.MAX_VALUE;
    private DijkstraVertex<Q> previous = null;

    // parlarsan anlarlar güneş misin ay mısın.
    private HashMap<DijkstraVertex<Q>, Double> connections = new HashMap<>();

    /**
     *
     */
    public DijkstraVertex(Q id) {
        this.id = id;
    }

    /**
     *
     * @return
     */
    public Double getWeight() {
        return weight;
    }

    /**
     *
     * @param weight
     */
    public void setWeight(Double weight) {
        this.weight = weight;
    }

    /**
     *
     * @return
     */
    public DijkstraVertex<Q> getPrevious() {
        return previous;
    }

    /**
     *
     * @param previous
     */
    public void setPrevious(DijkstraVertex<Q> previous) {
        this.previous = previous;
    }

    /**
     *
     * @return
     */
    public HashMap<DijkstraVertex<Q>, Double> getConnections() {
        return connections;
    }

    /**
     *
     * @param connections
     */
    public void setConnections(HashMap<DijkstraVertex<Q>, Double> connections) {
        this.connections = connections;
    }

    /**
     *
     * @return
     */
    public Q getId() {
        return id;
    }

    /**
     *
     * @param id
     */
    public void setId(Q id) {
        this.id = id;
    }

    @Override
    public int compareTo(WeightedVertex<Q> object) {
        return Double.compare(weight, (double) object.getWeight());
    }

    /**
     *
     * @return
     */
    public Map.Entry<Q, Double> toEntry() {
        return NativeEntry.of(getId(), getWeight());
    }

}
